<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Traits\Autenticable;
use DB;
use Logger;
use App\Models\Bodega;

class BodegaController extends Controller
{
    use Autenticable;

    public function index(Request $request)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $bodegas = DB::table('bodegas')
            ->select('ID_BODEGAS as id', 'NOMBRE_BODEGAS as nombre', 'ID_SUCURSAL as id_sucursal','ESTADO_BODEGAS as estado')
            ->whereRaw('ID_EMPRESA = \''.$usuario->rut_empresa.'\'')
            ->get();

        return response()->json($bodegas);
    }

    public function bodegasPorSucursal(Request $request, $id_sucursal)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $bodegas_segun_sucurdal = DB::table('bodegas')
            ->select('ID_BODEGAS as id', 'NOMBRE_BODEGAS as nombre', 'ID_SUCURSAL as id_sucursal','ESTADO_BODEGAS as estado')
            ->whereRaw('ID_EMPRESA = \''.$usuario->rut_empresa.'\'')
            ->whereRaw('ID_SUCURSAL = \''.$id_sucursal.'\'')
            ->get();

        return response()->json($bodegas_segun_sucurdal);
    }

    public function ingresar(Request $request)
    {
        $datos = $request->json()->all();

        $token = is_null($request->header('token')) ? $datos['token'] : $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $respuesta = [];

        Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            $datos,
            $respuesta,
            ENV('AMBIENTE_SII'),
            $request->ip()
        );


        $this->validateJson($request, [
            'nombre' => 'required|max:100',
            'descripcion' => 'required|max:100',
            'estado' => 'required|integer|in:0,1',
            'id_sucursal' => 'required|integer',
            'virtual' => 'sometimes|required|integer|in:0,1',
            'transito' => 'sometimes|required|integer|in:0,1',
            'woopy' => 'sometimes|required|integer|in:0,1',
            'principal' => 'sometimes|required|integer|in:0,1',
            'despacho' => 'sometimes|required|integer|in:0,1',
            'merma' => 'sometimes|required|integer|in:0,1',
        ]);
        $datos = $request->json()->all();



        $bodega = new Bodega(
                    $usuario->rut_empresa,
                    $datos['nombre'],
                    $datos['descripcion'],
                    $datos['id_sucursal'],
                    isset($datos['principal']) ? $datos['principal']:0,
                    isset($datos['despacho']) ? $datos['despacho']:0,
                    isset($datos['transito']) ? $datos['transito']:0,
                    isset($datos['merma']) ? $datos['merma']:0,
                    isset($datos['woopy']) ? $datos['woopy']:0,
                    $datos['estado']
                );

        $respuesta = $bodega->ingresarBodega();
        //dd($respuestas);
        //$respuestas[$item] = $emision_prefactura->ingresar();


        Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            json_encode(utf8_encode_recursivo((array)$request->all())),
            $respuesta,
            ENV('AMBIENTE_SII'),
            $request->ip()
        );

        return response()->json($respuesta);
    }

    public function actualizarBodega(Request $request, $bodega_id)
    {
        $datos = $request->json()->all();

        $token = is_null($request->header('token')) ? $datos['token'] : $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $respuesta = [];

        Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            $datos,
            $respuesta,
            ENV('AMBIENTE_SII'),
            $request->ip()
        );


        $this->validateJson($request, [
            'nombre' => 'required|max:100',
            'descripcion' => 'required|max:100',
            'estado' => 'required|integer|in:0,1',
            'id_sucursal' => 'required|integer',
            'virtual' => 'sometimes|required|integer|in:0,1',
            'transito' => 'sometimes|required|integer|in:0,1',
            'woopy' => 'sometimes|required|integer|in:0,1',
            'principal' => 'sometimes|required|integer|in:0,1',
            'despacho' => 'sometimes|required|integer|in:0,1',
            'merma' => 'sometimes|required|integer|in:0,1',
        ]);
        $datos = $request->json()->all();



        $bodega = new Bodega(
                    $usuario->rut_empresa,
                    $datos['nombre'],
                    $datos['descripcion'],
                    $datos['id_sucursal'],
                    isset($datos['principal']) ? $datos['principal']:0,
                    isset($datos['despacho']) ? $datos['despacho']:0,
                    isset($datos['transito']) ? $datos['transito']:0,
                    isset($datos['merma']) ? $datos['merma']:0,
                    isset($datos['woopy']) ? $datos['woopy']:0,
                    $datos['estado']
                );

        $respuesta = $bodega->actualizarBodega($bodega_id);


        Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            json_encode(utf8_encode_recursivo((array)$request->all())),
            $respuesta,
            ENV('AMBIENTE_SII'),
            $request->ip()
        );

        return response()->json($respuesta);
    }
}
