<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Traits\Autenticable;
use DB;

class VentasController extends Controller
{
    use Autenticable;

    public function obten_ventas_por_cobrar(Request $request)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $ventas_a_cobrar = DB::table('ctacte')
            ->select('ctacte.rut_c as rut_cliente', 'nombre_c as cliente',DB::raw('COUNT(ctacte.rut_c) as Documentos'),DB::raw('SUM(saldo_ctacte) as Monto'))

            ->Join('libro_ventas', function($q) {
                $q->on('ctacte.rut_empresa', '=', 'libro_ventas.rut');
                $q->on('ctacte.tipo_doc','=','libro_ventas.typo_doc');
                $q->on('ctacte.n_doc_ctacte','=','libro_ventas.n_doc');
            })

            ->where('RUT_EMPRESA', '=', $usuario->rut_empresa)
            ->where('saldo_ctacte', '!=', 0)
            ->where('CTACTE_LVENTA', '=', 1)
            ->groupBy('ctacte.rut_c')
            ->get();


        foreach ($ventas_a_cobrar as $key => $doc) {

            $doc->detalle[] = DB::table('ctacte')
            ->select('libro_ventas.fecha as fecha', 'libro_ventas.typo_doc as tipo', 'libro_ventas.n_doc as folio', 'libro_ventas.valor_n as neto', 'libro_ventas.valor_i as iva', 'libro_ventas.valor_t as total')

            ->Join('libro_ventas', function($q) {
                $q->on('ctacte.rut_empresa', '=', 'libro_ventas.rut');
                $q->on('ctacte.tipo_doc','=','libro_ventas.typo_doc');
                $q->on('ctacte.n_doc_ctacte','=','libro_ventas.n_doc');
            })

            ->where('RUT_EMPRESA', '=', $usuario->rut_empresa)
            ->where('ctacte.rut_c', '=', $doc->rut_cliente)
            ->where('saldo_ctacte', '!=', 0)
            ->where('CTACTE_LVENTA', '=', 1)
            ->get();


            //dd($doc->detalle);
        }

        return response()->json((array) $ventas_a_cobrar);
    }

    public function obten_ventas_por_dia(Request $request, $fecha)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        //SELECT rut_c,nombre_c,EXENTO_LVENTA,valor_n,valor_i,valor_t FROM `libro_ventas` WHERE rut='22222222-2' AND fecha='2021-04-01' ORDER BY `libro_ventas`.`ID_LV` DESC

        $ventas_por_dia = DB::table('libro_ventas')
            ->select('fecha','typo_doc','n_doc','rut_c','nombre_c','EXENTO_LVENTA','valor_n','valor_i','valor_t')
            ->where ('rut','=', $usuario->rut_empresa)
            ->where ('fecha','=', $fecha)
            ->whereRaw('typo_doc in(33,34,39,61,56,110,111,112)')
            ->get();


        return response()->json((array) $ventas_por_dia);
    }

    public function obten_ventas_por_mes(Request $request)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $item = 0;
        $respuestas = [];
        try{
            $this->validateArray($request, $datos, [
                'periodo' => 'required|max:4|min:4',
                'mes' => 'required|max:2|max:2',
            ]);
        }catch(Exception $e) {
            $respuestas[$item] = (array) $e->getResponse()->getData();
        }


        $ventas_por_dia = DB::table('libro_ventas')
            ->select('fecha','typo_doc','n_doc','rut_c','nombre_c','EXENTO_LVENTA','valor_n','valor_i','valor_t')
            ->where ('rut','=', $usuario->rut_empresa)
            ->whereRaw('mes = \''.$datos['mes'].'\'')
            ->whereRaw('ANO_LVENTA = \''.$datos['periodo'].'\'')
            ->whereRaw('typo_doc in(33,34,39,61,56,110,111,112)')
            ->get();


        return response()->json((array) $ventas_por_dia);
    }

    public function obten_ventas_por_mes_por_producto(Request $request, $codigo)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $item = 0;
        $respuestas = [];
        try{
            $this->validateArray($request, $datos, [
                'periodo' => 'required|max:4|min:4',
                'mes' => 'required|max:2|max:2',
            ]);
        }catch(Exception $e) {
            $respuestas[$item] = (array) $e->getResponse()->getData();
        }


        $ventas = DB::table('libro_ventas')
            ->select('fecha','typo_doc','n_doc','rut_c','nombre_c','EXENTO_LVENTA','valor_n','valor_i','valor_t')
            ->where ('rut','=', $usuario->rut_empresa)
            ->whereRaw('mes = \''.$datos['mes'].'\'')
            ->whereRaw('ANO_LVENTA = \''.$datos['periodo'].'\'')
            ->whereRaw('typo_doc in(33,34,39,61,56,110,111,112)')
            ->Join('detalle_doc2 AS d', function ($join) use ($codigo) {
                $join->on('d.RUT_EMPRESA', '=', 'libro_ventas.rut');
                $join->on('d.ID_TIPODOC', '=', 'libro_ventas.typo_doc');
                $join->on('d.ID_CORRE_DETALLEDOC', '=', 'libro_ventas.n_doc');
                $join->where('d.CPROD_DETALLEDOC', '=', $codigo);

            })
            ->Join('productos AS p', function ($join) {
                $join->on('p.ID_EMPRESA', '=', 'd.RUT_EMPRESA');
                $join->on('p.CODIGO_PRODUCTO', '=', 'd.CPROD_DETALLEDOC');
            })
            ->get();


        return response()->json((array) $ventas);
    }

    public function obtenVentasPorCobrarPorCliente(Request $request, $rut)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $ventas_a_cobrar = DB::table('ctacte')
            ->select('ctacte.tipo_doc', 'ctacte.n_doc_ctacte','libro_ventas.fecha','total_ctacte as total','pagos_ctacte as abono','saldo_ctacte as monto')

            ->Join('libro_ventas', function($q) {
                $q->on('ctacte.rut_empresa', '=', 'libro_ventas.rut');
                $q->on('ctacte.tipo_doc','=','libro_ventas.typo_doc');
                $q->on('ctacte.n_doc_ctacte','=','libro_ventas.n_doc');
            })

            ->where('RUT_EMPRESA', '=', $usuario->rut_empresa)
            ->where('saldo_ctacte', '!=', 0)
            ->where('CTACTE_LVENTA', '=', 1)
            ->where('ctacte.rut_c', '=', $rut)
            ->get();

        return response()->json((array) $ventas_a_cobrar);
    }
}
