<?php

namespace App\Models;
use DB;
use App\Models\Sucursal;

class Bodega
{

    public function __construct(
            $rut_empresa,
            $nombre,
            $descripcion,
            $id_sucursal,
            $principal,
            $despacho,
            $transito,
            $merma,
            $woopy,
            $estado
        )
    {
        $this->rut_empresa = $rut_empresa;
        $this->nombre = $nombre;
        $this->descripcion = $descripcion;
        $this->id_sucursal = $id_sucursal;
        $this->principal = $principal;
        $this->despacho = $despacho;
        $this->transito = $transito;
        $this->merma = $merma;
        $this->woopy = $woopy;
        $this->estado = $estado;
    }

    public function ingresarBodega()
    {
        // validar que id sucursal exista
        $sucursal = Sucursal::obtenSucursal($this->id_sucursal, $this->rut_empresa);
        if(is_null($sucursal)) {
            $mensaje = 'Id sucursal '.$this->id_sucursal.' no existe.';
            return ['mensaje' => $mensaje];
        }

        //validar que no exista el nombre de bodega
        $verificaNombre = self::verifcaNombreBodega($this->nombre, $this->rut_empresa);
        if (!is_null($verificaNombre)) {
            $mensaje = 'Bodega '.$this->nombre.' ya existe.';
            return ['mensaje' => $mensaje];
        }


        $id_bodega = $this->ingresoBodega();
        if(!$id_bodega){
            return $this->fallo('Excepción al ingresar datos Bodega.');
        }

        $respuesta['id'] = $id_bodega;
        $respuesta['nombre'] = $this->nombre;
        return $respuesta;
    }

    public function actualizarBodega($bodega_id)
    {

        // validar que id sucursal exista
        $sucursal = Sucursal::obtenSucursal($this->id_sucursal, $this->rut_empresa);
        if(is_null($sucursal)) {
            $mensaje = 'Id sucursal '.$this->id_sucursal.' no existe.';
            return ['mensaje' => $mensaje];
        }

        //validar que no exista el nombre de bodega
        $verificaNombre = self::verifcaNombreBodega($this->nombre, $this->rut_empresa);
        if (!is_null($verificaNombre)) {
            $mensaje = 'Bodega '.$this->nombre.' ya existe.';
            return ['mensaje' => $mensaje];
        }

        try{
            $actualizar_vendedor = DB::table('bodegas')
                ->whereRaw('ID_EMPRESA = \''.$this->rut_empresa.'\'')
                ->whereRaw('ID_BODEGAS = \''.$bodega_id.'\'')
                ->update([
                    'NOMBRE_BODEGAS' => $this->nombre,
                    'ID_SUCURSAL' => $this->id_sucursal,
                    'ESTADO_BODEGAS' => $this->estado,
                    'ADICIONAL1_BODEGAS' => $this->descripcion,
                    'PRINCIPAL' => $this->principal,
                    'DESPACHO' => $this->despacho,
                    'TRANSITO' => $this->transito,
                    'merma' => $this->merma,
                    'woopy' => $this->woopy,
                ]);

        }catch(Exception $e) {
            $respuesta[] = [$this->nombre => "Error al actualizar vendedor."];
            return response()->json($respuestas);
        }

        $respuesta['id'] = $bodega_id;
        $respuesta['nombre'] = $this->nombre;
        $respuesta['mensaje'] = 'Bodega actualizada con exito.';

        return $respuesta;

        //return response()->json($respuesta);
    }


    protected function ingresoBodega()
    {
        try{

        $id_bodega = DB::table('bodegas')
            ->insertGetId([
                'ID_EMPRESA' => $this->rut_empresa,
                'NOMBRE_BODEGAS' => $this->nombre,
                'ID_SUCURSAL' => $this->id_sucursal,
                'ORDENCARGA_BODEGAS' => '',
                'ESTADO_BODEGAS' => $this->estado,
                'INVENTARIO_BODEGAS' => '',
                'ADICIONAL1_BODEGAS' => $this->descripcion,
                'PRINCIPAL' => $this->principal,
                'ADICIONAL3_BODEGAS' => '',
                'DESPACHO' => $this->despacho,
                'TRANSITO' => $this->transito,
                'merma' => $this->merma,
                'woopy' => $this->woopy,
            ]);
        }catch (Exception $e) {
            return false;
        }

        return $id_bodega;
    }


    public static function verifcaNombreBodega($nombre, $rut_emisor)
    {
        return DB::table('bodegas')
            ->where('NOMBRE_BODEGAS', '=', $nombre)
            ->whereRaw('ID_EMPRESA = \''.$rut_emisor.'\'')
            ->first();
    }

    public static function obtenBodega($id, $rut_emisor)
    {
        return DB::table('bodegas')
            ->where('ID_BODEGAS', '=', $id)
            ->whereRaw('ID_EMPRESA = \''.$rut_emisor.'\'')
            ->first();
    }

    public static function obtenBodegaWoopy($rut_emisor)
    {
        return DB::table('bodegas')
            ->where('woopy', '=', '1')
            ->whereRaw('ID_EMPRESA = \''.$rut_emisor.'\'')
            ->first();
    }
}
