<?php

namespace App\Traits;

use DB;

trait Foliable
{
    function obtenFolio($rut_empresa, $tipo_documento, $folio = null)
    {
        if(!empty($folio)) {
            return $folio;
        }

        $corre_folio = DB::table('folio_sin_ocupar')
            ->whereRaw('id_empresa = \''. $rut_empresa.'\'')
            ->where('typo_doc', '=', $tipo_documento)
            ->where('estado', '=', '0')
            ->first();

        if(!empty($corre_folio)) {
            DB::table('folio_sin_ocupar')
            ->whereRaw('id_empresa = \''. $rut_empresa.'\'')
            ->where('typo_doc', '=', $tipo_documento)
            ->update([
                'estado' => 1,
            ]);
            return $corre_folio->folio;
        }



        $corre_folio = DB::table('corre_folios')
            ->whereRaw('RUT_EMPRESA = \''. $rut_empresa.'\'')
            ->where('CODIGO', '=', $tipo_documento)
            ->first();


        if(empty($corre_folio)) {
            $folio = DB::table('libro_ventas')
                ->where('rut', '=', $rut_empresa)
                ->where('typo_doc', '=', $tipo_documento)
                ->max('n_doc');
            return is_null($folio) ? 1 : $folio + 1;
        }


        DB::table('corre_folios')
            ->where('RUT_EMPRESA', '=', $rut_empresa)
            ->where('CODIGO', '=', $tipo_documento)
            ->update([
                'FOLIO' => $corre_folio->FOLIO + 1
            ]);
        return $corre_folio->FOLIO;
    }

    function verificaFolioSoftnet($rut_empresa, $tipo_documento, $folio){
        $folio = DB::table('libro_ventas')
            ->whereRaw('rut = \''. $rut_empresa.'\'')
            ->where('typo_doc', '=', $tipo_documento)
            ->where('n_doc', '=', $folio)
            ->first();

        return $folio;
    }


    function registraFolioSinOcupar($rut_empresa, $tipo_documento, $folio)
    {
        return DB::table('folio_sin_ocupar')
            ->insert([
                'id_empresa' => $rut_empresa,
                'folio' => $folio,
                'typo_doc' => $tipo_documento,
            ]);
    }

    function existeFolio($rut_empresa, $tipo_documento, $folio)
    {
        $folioExiste = DB::table('libro_ventas')
            ->where('rut', '=', $rut_empresa)
            ->where('typo_doc', '=', $tipo_documento)
            ->where('n_doc', '=', $folio)
            ->max('n_doc');

        if (!empty($folioExiste)) {
            return true;
        }else {
            return false;
        }


    }
    function existeFolioGuiaDespacho($rut_empresa, $tipo_documento, $folio)
    {
        $folioExiste = DB::table('libro_guias')
            ->where('rut', '=', $rut_empresa)
            ->where('typo_doc', '=', $tipo_documento)
            ->where('n_doc', '=', $folio)
            ->max('n_doc');

        if (!empty($folioExiste)) {
            return true;
        }else {
            return false;
        }


    }
}
