<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Traits\Autenticable;
use DB;


class BancoController extends Controller
{
    use Autenticable;

    public function index(Request $request)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $bancos = DB::table('cbancos')
            ->select('ID_CBANCOS as id', 'ID_CUENTA as cuenta_contable', 'NOMBRE_CBANCOS as nombre', 'DESCRIPCION_CBANCOS as descripcion', 'alias as alias', 'ESTADO as estado')
            ->whereRaw('ID_EMPRESA = \''.$usuario->rut_empresa.'\'')
            ->get();
        //dd($usuario->rut_empresa);

        return response()->json((array) $bancos);
    }

    public function listaBancos(Request $request)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $bancos = DB::table('bancos')
            ->select('ID_BANCO as id', 'NOMBRE_BANCO as nombre')
            ->whereRaw('ACTIVO_BANCO = 1')
            ->get();
        //dd($usuario->rut_empresa);

        return response()->json((array) $bancos);
    }
    //
}
