<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Traits\Autenticable;
use DB;

class LibroController extends Controller
{
    use Autenticable;

    public function getLibroVentas(Request $request)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $item = 0;
        $respuestas = [];
        try{
            $this->validateArray($request, $datos, [
                'periodo' => 'required|max:4|min:4',
                'mes' => 'required|max:2|max:2',
                'pendiente' => 'sometimes|required|in:1,2'
            ]);
        }catch(Exception $e) {
            $respuestas[$item] = (array) $e->getResponse()->getData();
        }

        
        $bodegas = DB::table('libro_ventas')
            ->select(
                'fecha as fecha',
                'typo_doc as tipo_doc',
                'n_doc as folio',
                'rut_c as rut_cliente',
                'nombre_c as razon_social',
                'EXENTO_LVENTA as valor_exento',
                'DESCUENTO_LVENTA as descuento',
                'valor_n as valor_neto',
                'valor_i as valor_iva',
                'valor_t as valor_total',
                'OBS_LVENTA as observacion',
                'ANEGOCIO_LVENTA as id_area_negocio'
            )
            ->whereRaw('rut = \''.$usuario->rut_empresa.'\'')
            ->whereRaw('mes = \''.$datos['mes'].'\'')
            ->whereRaw('ANO_LVENTA = \''.$datos['periodo'].'\'')
            ->whereRaw('typo_doc in(33,34,39,61,56,110,111,112)')
            ->get();

        if(!empty($datos['pendiente'])){
            $bodegas = DB::table('libro_ventas')
            ->select(
                'fecha as fecha',
                'typo_doc as tipo_doc',
                'n_doc as folio',
                'rut_c as rut_cliente',
                'nombre_c as razon_social',
                'EXENTO_LVENTA as valor_exento',
                'DESCUENTO_LVENTA as descuento',
                'valor_n as valor_neto',
                'valor_i as valor_iva',
                'valor_t as valor_total',
                'OBS_LVENTA as observacion',
                'ANEGOCIO_LVENTA as id_area_negocio'
            )
            ->whereRaw('rut = \''.$usuario->rut_empresa.'\'')
            ->whereRaw('mes = \''.$datos['mes'].'\'')
            ->whereRaw('ANO_LVENTA = \''.$datos['periodo'].'\'')
            ->whereRaw('CTACTE_LVENTA = \''.$datos['pendiente'].'\'')
            ->whereRaw('typo_doc in(33,34,39,61,56,110,111,112)')
            ->get();
        }

        return response()->json($bodegas);
    }

    public function getLibroVentasDetalle(Request $request, $rut_cliente)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $item = 0;
        $respuestas = [];

        /*try{
            $this->validateArray($request, $datos, [
                'periodo' => 'required|max:4|min:4',
                'mes' => 'required|max:2|max:2',
            ]);
        }catch(Exception $e) {
            $respuestas[$item] = (array) $e->getResponse()->getData();
        }*/

        $libro_ventas = DB::table('libro_ventas')
            ->select(
                'fecha as fecha',
                'typo_doc as tipo_doc',
                'n_doc as folio',
                'rut_c as rut_cliente',
                'nombre_c as razon_social',
                'EXENTO_LVENTA as valor_exento',
                'DESCUENTO_LVENTA as descuento',
                'valor_n as valor_neto',
                'valor_i as valor_iva',
                'valor_t as valor_total',
                'OBS_LVENTA as observacion',
                'ANEGOCIO_LVENTA as id_area_negocio'
            )
            ->whereRaw('rut = \''.$usuario->rut_empresa.'\'')
            //->whereRaw('mes = \''.$datos['mes'].'\'')
            ->whereRaw('rut_c = \''.$rut_cliente.'\'')
            //->whereRaw('ANO_LVENTA = \''.$datos['periodo'].'\'')
            ->whereRaw('typo_doc in(33,34,39,61,56,110,111,112)')
            ->get();

        return response()->json($libro_ventas);
    }

    public function getLibroVentasConDetalle(Request $request)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $item = 0;
        $respuestas = [];
        try{
            $this->validateArray($request, $datos, [
                'periodo' => 'required|max:4|min:4',
                'mes' => 'required|min:2|max:2',
                'tipo_documento' => 'required|min:2|max:3'
            ]);
        }catch(Exception $e) {
            $respuestas[$item] = (array) $e->getResponse()->getData();
        }



        $docs = DB::table('libro_ventas')
            ->select(
                'ID_LV as id',
                'fecha as fecha',
                'typo_doc as tipo_doc',
                'n_doc as folio',
                'rut_c as rut_cliente',
                'nombre_c as razon_social',
                'EXENTO_LVENTA as valor_exento',
                'DESCUENTO_LVENTA as descuento',
                'valor_n as valor_neto',
                'valor_i as valor_iva',
                'valor_t as valor_total',
                'OBS_LVENTA as observacion',
                'ANEGOCIO_LVENTA as id_area_negocio'
                )
            ->whereRaw('rut = \''.$usuario->rut_empresa.'\'')
            ->whereRaw('ANO_LVENTA = \''.$datos['periodo'].'\'')
            ->whereRaw('mes = \''.$datos['mes'].'\'')
            ->whereRaw('typo_doc = \''.$datos['tipo_documento'].'\'')
            ->whereRaw('typo_doc in(33,34,39,61,56,110,111,112)')
            ->get();



        $doc_temp = array();
        $documento = array();
        foreach ($docs as $key => $doc) {
            // code...
            $doc_temp['fecha'] = $doc->fecha;
            $doc_temp['tipo_doc'] = $doc->tipo_doc;
            $doc_temp['folio'] = $doc->folio;
            $doc_temp['rut_cliente'] = $doc->rut_cliente;
            $doc_temp['razon_social'] = $doc->razon_social;
            $doc_temp['valor_exento'] = $doc->valor_exento;
            $doc_temp['descuento'] = $doc->descuento;
            $doc_temp['valor_neto'] = $doc->valor_neto;
            $doc_temp['valor_iva'] = $doc->valor_iva;
            $doc_temp['valor_total'] = $doc->valor_total;
            $doc_temp['observacion'] = $doc->observacion;
            $doc_temp['id_area_negocio'] = $doc->id_area_negocio;

            $contactos = DB::table('clienteproveedor_contacto')
                ->select(
                    'nombre as nombre',
                    'cargo as cargo',
                    'email as email',
                    'telefono_oficina as telefono1',
                    'telefono_celular as telefono2',
                    'cobranza as cobranza',
                    'estado as estado'
                )
                ->whereRaw('rut_empresa = \''.$usuario->rut_empresa.'\'')
                ->whereRaw('rut_cliente = \''.$doc->rut_cliente.'\'')
                ->get();
            $doc_temp['contactos'] = $contactos;

            $detalles = DB::table('detalle_doc2')
                ->select(
                    'CPROD_DETALLEDOC as codigo',
                    'DETALLE_DETALLEDOC as detalle',
                    'CANTIDAD_DETALLEDOC as cantidad',
                    'EXENTO_DETALLEDOC as exento',
                    'NETO_DETALLEDOC as neto',
                    'TIPODESC__DETALLEDOC as tipoDescuento',
                    'VADESC__DETALLEDOC as valorDescuento',
                    'DESC__DETALLEDOC as montoDescuento',
                    'TOTAL_DETALLEDOC as total'
                )
                ->whereRaw('RUT_EMPRESA = \''.$usuario->rut_empresa.'\'')
                ->whereRaw('ID_TIPODOC = \''.$doc->tipo_doc.'\'')
                ->whereRaw('ID_CORRE_DETALLEDOC = \''.$doc->folio.'\'')
                ->get();
            foreach ($detalles as $key => $detalle) {
                // code...
                $detalle_temp['codigo'] = $detalle->codigo;
                $detalle_temp['detalle'] = $detalle->detalle;
                $detalle_temp['exento'] = $detalle->exento;
                $detalle_temp['cantidad'] = $detalle->cantidad;
                $detalle_temp['neto'] = $detalle->neto;
                $detalle_temp['tipoDescuento'] = $detalle->tipoDescuento;
                $detalle_temp['valorDescuento'] = $detalle->valorDescuento;
                $detalle_temp['montoDescuento'] = $detalle->montoDescuento;
                $detalle_temp['total'] = $detalle->total;

                $detalle_temp_final[] = $detalle_temp;
            }

            $doc_temp['detalles'] = $detalle_temp_final;
            unset($detalle_temp_final);

            $documento[$doc->id] = $doc_temp;

        }


        return response()->json($documento);
    }
    public function getLibroVentasConDetallePorFecha(Request $request)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $item = 0;
        $respuestas = [];
        try{
            $this->validateArray($request, $datos, [
                'tipo_documento' => 'required|min:2|max:3',
                'fecha' => 'required|date'
            ]);
        }catch(Exception $e) {
            $respuestas[$item] = (array) $e->getResponse()->getData();
        }



        $docs = DB::table('libro_ventas')
            ->select(
                'ID_LV as id',
                'fecha as fecha',
                'typo_doc as tipo_doc',
                'n_doc as folio',
                'rut_c as rut_cliente',
                'nombre_c as razon_social',
                'EXENTO_LVENTA as valor_exento',
                'DESCUENTO_LVENTA as descuento',
                'valor_n as valor_neto',
                'valor_i as valor_iva',
                'valor_t as valor_total',
                'OBS_LVENTA as observacion',
                'ANEGOCIO_LVENTA as id_area_negocio'
                )
            ->whereRaw('rut = \''.$usuario->rut_empresa.'\'')
            ->whereRaw('fecha = \''.$datos['fecha'].'\'')
            ->whereRaw('typo_doc = \''.$datos['tipo_documento'].'\'')
            ->whereRaw('typo_doc in(33,34,39,61,56,110,111,112)')
            ->get();

        $doc_temp = array();
        $documento = array();
        foreach ($docs as $key => $doc) {
            // code...
            $doc_temp['fecha'] = $doc->fecha;
            $doc_temp['tipo_doc'] = $doc->tipo_doc;
            $doc_temp['folio'] = $doc->folio;
            $doc_temp['rut_cliente'] = $doc->rut_cliente;
            $doc_temp['razon_social'] = $doc->razon_social;
            $doc_temp['valor_exento'] = $doc->valor_exento;
            $doc_temp['descuento'] = $doc->descuento;
            $doc_temp['valor_neto'] = $doc->valor_neto;
            $doc_temp['valor_iva'] = $doc->valor_iva;
            $doc_temp['valor_total'] = $doc->valor_total;
            $doc_temp['observacion'] = $doc->observacion;
            $doc_temp['id_area_negocio'] = $doc->id_area_negocio;

            $contactos = DB::table('clienteproveedor_contacto')
                ->select(
                    'nombre as nombre',
                    'cargo as cargo',
                    'email as email',
                    'telefono_oficina as telefono1',
                    'telefono_celular as telefono2',
                    'cobranza as cobranza',
                    'estado as estado'
                )
                ->whereRaw('rut_empresa = \''.$usuario->rut_empresa.'\'')
                ->whereRaw('rut_cliente = \''.$doc->rut_cliente.'\'')
                ->get();
            $doc_temp['contactos'] = $contactos;

            $detalles = DB::table('detalle_doc2')
                ->select(
                    'CPROD_DETALLEDOC as codigo',
                    'DETALLE_DETALLEDOC as detalle',
                    'CANTIDAD_DETALLEDOC as cantidad',
                    'EXENTO_DETALLEDOC as exento',
                    'NETO_DETALLEDOC as neto',
                    'TIPODESC__DETALLEDOC as tipoDescuento',
                    'VADESC__DETALLEDOC as valorDescuento',
                    'DESC__DETALLEDOC as montoDescuento',
                    'TOTAL_DETALLEDOC as total'
                )
                ->whereRaw('RUT_EMPRESA = \''.$usuario->rut_empresa.'\'')
                ->whereRaw('ID_TIPODOC = \''.$doc->tipo_doc.'\'')
                ->whereRaw('ID_CORRE_DETALLEDOC = \''.$doc->folio.'\'')
                ->get();
            foreach ($detalles as $key => $detalle) {
                // code...
                $detalle_temp['codigo'] = $detalle->codigo;
                $detalle_temp['detalle'] = $detalle->detalle;
                $detalle_temp['exento'] = $detalle->exento;
                $detalle_temp['cantidad'] = $detalle->cantidad;
                $detalle_temp['neto'] = $detalle->neto;
                $detalle_temp['tipoDescuento'] = $detalle->tipoDescuento;
                $detalle_temp['valorDescuento'] = $detalle->valorDescuento;
                $detalle_temp['montoDescuento'] = $detalle->montoDescuento;
                $detalle_temp['total'] = $detalle->total;

                $detalle_temp_final[] = $detalle_temp;
            }

            $doc_temp['detalles'] = $detalle_temp_final;

            unset($detalle_temp_final);

            $documento[$doc->id] = $doc_temp;

        }


        return response()->json($documento);
    }

    public function getLibroCompras(Request $request)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $item = 0;
        $respuestas = [];
        try{
            $this->validateArray($request, $datos, [
                'periodo' => 'required|max:4|min:4',
                'mes' => 'required|max:2|max:2',
            ]);
        }catch(Exception $e) {
            $respuestas[$item] = (array) $e->getResponse()->getData();
        }


        $registros = DB::table('libro_compras3')
            ->select(
                'fecha as fecha',
                'typo_doc as tipo_doc',
                'n_doc as folio',
                'rut_c as rut_cliente',
                'nombre_c as razon_social',
                'EXENTO_LCOMPRAS as valor_exento',
                'DESCUENTO_LCOMPRAS as descuento',
                'valor_n as valor_neto',
                'valor_i as valor_iva',
                'valor_t as valor_total',
                'OBS_LCOMPRAS as observacion'
            )
            ->whereRaw('rut = \''.$usuario->rut_empresa.'\'')
            ->whereRaw('mes = \''.$datos['mes'].'\'')
            ->whereRaw('ANO_LCOMPRAS = \''.$datos['periodo'].'\'')
            ->whereRaw('INTERNO_LCOMPRAS <> "" ')
            ->whereRaw('DISPONIBLE5_LCOMPRAS <> 2 ')
            ->whereRaw('typo_doc <> 35 ')
            ->whereRaw('typo_doc <> 52 ')
            ->get();

        return response()->json($registros);
    }

    public function getLibroComprasCliente(Request $request, $rut)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $bodegas = DB::table('libro_compras3')
            ->select('fecha as fecha', 'typo_doc as tipo_doc', 'n_doc as folio', 'rut_c as rut_cliente', 'nombre_c as razon_social', 'valor_t as valor_total')
            ->whereRaw('rut = \''.$usuario->rut_empresa.'\'')
            ->whereRaw('rut_c = \''.$rut.'\'')
            ->get();

        return response()->json($bodegas);
    }

    public function getLibroGuias(Request $request)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $item = 0;
        $respuestas = [];
        try{
            $this->validateArray($request, $datos, [
                'periodo' => 'required|max:4|min:4',
                'mes' => 'required|max:2|max:2',
            ]);
        }catch(Exception $e) {
            $respuestas[$item] = (array) $e->getResponse()->getData();
        }

        $data = DB::table('libro_guias')
            ->select(
                'fecha as fecha',
                'typo_doc as tipo_doc',
                'n_doc as folio',
                'rut_c as rut_cliente',
                'nombre_c as razon_social',
                'EXENTO_LVENTA as valor_exento',
                'DESCUENTO_LVENTA as descuento',
                'valor_n as valor_neto',
                'valor_i as valor_iva',
                'valor_t as valor_total',
                'OBS_LVENTA as observacion',
                'ANEGOCIO_LVENTA as id_area_negocio',
                'ESTADO as estado'
            )
            ->whereRaw('rut = \''.$usuario->rut_empresa.'\'')
            ->whereRaw('mes = \''.$datos['mes'].'\'')
            ->whereRaw('ANO_LVENTA = \''.$datos['periodo'].'\'')
            ->get();
        
            $estados = DB::table('estado_guia_d')
            ->get();
            
            $listaEstado = array();
            foreach ($estados as $key => $e) {
                $listaEstado[$e->codigo] = $e->estado;
            }
            
        foreach ($data as $key => $g) {
            $estadoGuia['id'] = $g->estado;
            $estadoGuia['nombre'] = $listaEstado[$g->estado];
            $g->estados = $estadoGuia;
        }

            
        return response()->json($data);
    }

    public function getLibroCotizacion(Request $request)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $item = 0;
        $respuestas = [];
        try{
            $this->validateArray($request, $datos, [
                'periodo' => 'required|max:4|min:4',
                'mes' => 'required|max:2|max:2',
                'estado' => 'sometimes|required',
            ]);
        }catch(Exception $e) {
            $respuestas[$item] = (array) $e->getResponse()->getData();
        }

        $resultados = DB::table('libro_ventas')
            ->select(
                'fecha as fecha',
                'typo_doc as tipo_doc',
                'n_doc as folio',
                'rut_c as rut_cliente',
                'nombre_c as razon_social',
                'EXENTO_LVENTA as valor_exento',
                'DESCUENTO_LVENTA as descuento',
                'valor_n as valor_neto',
                'valor_i as valor_iva',
                'valor_t as valor_total',
                'OBS_LVENTA as observacion',
                'ANEGOCIO_LVENTA as id_area_negocio',
                'ID_ENVIO as estado_cotizacion'
            )
            ->whereRaw('rut = \''.$usuario->rut_empresa.'\'')
            ->whereRaw('typo_doc = 777')
            ->whereRaw('mes = \''.$datos['mes'].'\'')
            ->whereRaw('ANO_LVENTA = \''.$datos['periodo'].'\'')
            ->get();

            if(!empty($datos['estado'])){
                $resultados = DB::table('libro_ventas')
                ->select(
                    'fecha as fecha',
                    'typo_doc as tipo_doc',
                    'n_doc as folio',
                    'rut_c as rut_cliente',
                    'nombre_c as razon_social',
                    'EXENTO_LVENTA as valor_exento',
                    'DESCUENTO_LVENTA as descuento',
                    'valor_n as valor_neto',
                    'valor_i as valor_iva',
                    'valor_t as valor_total',
                    'OBS_LVENTA as observacion',
                    'ANEGOCIO_LVENTA as id_area_negocio',
                    'ID_ENVIO as estado_cotizacion'
                )
                ->whereRaw('rut = \''.$usuario->rut_empresa.'\'')
                ->whereRaw('typo_doc = 777')
                ->whereRaw('mes = \''.$datos['mes'].'\'')
                ->whereRaw('ANO_LVENTA = \''.$datos['periodo'].'\'')
                ->whereRaw('ID_ENVIO = \''.$datos['estado'].'\'')
                ->get();
                
            }

        return response()->json($resultados);
    }

    public function getLibroNotaVenta(Request $request)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $item = 0;
        $respuestas = [];
        try{
            $this->validateArray($request, $datos, [
                'periodo' => 'required|max:4|min:4',
                'mes' => 'required|max:2|max:2',
            ]);
        }catch(Exception $e) {
            $respuestas[$item] = (array) $e->getResponse()->getData();
        }

        $bodegas = DB::table('libro_ventas')
            ->select(
                'fecha as fecha',
                'typo_doc as tipo_doc',
                'n_doc as folio',
                'rut_c as rut_cliente',
                'nombre_c as razon_social',
                'EXENTO_LVENTA as valor_exento',
                'DESCUENTO_LVENTA as descuento',
                'valor_n as valor_neto',
                'valor_i as valor_iva',
                'valor_t as valor_total',
                'OBS_LVENTA as observacion',
                'ANEGOCIO_LVENTA as id_area_negocio'
                )
            ->whereRaw('rut = \''.$usuario->rut_empresa.'\'')
            ->whereRaw('typo_doc = 780')
            ->whereRaw('mes = \''.$datos['mes'].'\'')
            ->whereRaw('ANO_LVENTA = \''.$datos['periodo'].'\'')
            ->get();

        return response()->json($bodegas);
    }
    public function getLibroNotaVentaFecha(Request $request, $fecha)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $item = 0;
        $respuestas = [];

        $bodegas = DB::table('libro_ventas')
            ->select(
                'fecha as fecha',
                'typo_doc as tipo_doc',
                'n_doc as folio',
                'rut_c as rut_cliente',
                'nombre_c as razon_social',
                'EXENTO_LVENTA as valor_exento',
                'DESCUENTO_LVENTA as descuento',
                'valor_n as valor_neto',
                'valor_i as valor_iva',
                'valor_t as valor_total',
                'OBS_LVENTA as observacion',
                'ANEGOCIO_LVENTA as id_area_negocio'
                )
            ->whereRaw('rut = \''.$usuario->rut_empresa.'\'')
            ->whereRaw('typo_doc = 780')
            ->whereRaw('fecha = \''.$fecha.'\'')
            ->get();

        return response()->json($bodegas);
    }

    public function getLibroOrdenCompra(Request $request)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $item = 0;
        $respuestas = [];
        try{
            $this->validateArray($request, $datos, [
                'periodo' => 'required|max:4|min:4',
                'mes' => 'required|max:2|max:2',
            ]);
        }catch(Exception $e) {
            $respuestas[$item] = (array) $e->getResponse()->getData();
        }

        $bodegas = DB::table('libro_ventas')
            ->select(
                'fecha as fecha',
                'typo_doc as tipo_doc',
                'n_doc as folio',
                'rut_c as rut_cliente',
                'nombre_c as razon_social',
                'EXENTO_LVENTA as valor_exento',
                'DESCUENTO_LVENTA as descuento',
                'valor_n as valor_neto',
                'valor_i as valor_iva',
                'valor_t as valor_total',
                'OBS_LVENTA as observacion',
                'ANEGOCIO_LVENTA as id_area_negocio'
                )
            ->whereRaw('rut = \''.$usuario->rut_empresa.'\'')
            ->whereRaw('typo_doc = 801')
            ->whereRaw('mes = \''.$datos['mes'].'\'')
            ->whereRaw('ANO_LVENTA = \''.$datos['periodo'].'\'')
            ->get();

        return response()->json($bodegas);
    }

    public function getCotizacionPorProducto(Request $request)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $item = 0;
        $respuestas = [];
        try{
            $this->validateArray($request, $datos, [
                'codigo' => 'required',
                'periodo' => 'required|max:4|min:4',
                'mes' => 'required|max:2',
            ]);
        }catch(Exception $e) {
            $respuestas[$item] = (array) $e->getResponse()->getData();
        }


        $datos = DB::table('libro_ventas')
            ->Join('detalle_doc2', function ($join) {
                $join->on('detalle_doc2.RUT_EMPRESA', '=', 'libro_ventas.rut');
                $join->on('detalle_doc2.ID_TIPODOC', '=', 'libro_ventas.typo_doc');
                $join->on('detalle_doc2.ID_CORRE_DETALLEDOC', '=', 'libro_ventas.n_doc');
            })
            ->Join('estado_cotizacion', function ($join) {
                $join->on('libro_ventas.ID_ENVIO', '=', 'estado_cotizacion.codigo');
            })
            ->Join('vendedores', function ($join) {
                $join->on('libro_ventas.DISPONIBLE2_LVENTA', '=', 'vendedores.RUT_VENDEDOR');
            })
            ->select(
                'fecha as fecha',
                'typo_doc as tipo_doc',
                'n_doc as folio',
                'rut_c as rut_cliente',
                'nombre_c as razon_social',
                'EXENTO_LVENTA as valor_exento',
                'DESCUENTO_LVENTA as descuento',
                'valor_n as valor_neto',
                'valor_i as valor_iva',
                'valor_t as valor_total',
                'DISPONIBLE2_LVENTA as rut_vendedor',
                'vendedores.NOMBRE_VENDEDOR as nombre_vendedor',
                'estado_cotizacion.estado as estado'
                )

            ->where('libro_ventas.typo_doc', '=', '777')
            ->whereRaw('libro_ventas.rut = \''.$usuario->rut_empresa.'\'')
            ->whereRaw('detalle_doc2.CPROD_DETALLEDOC = \''.$datos['codigo'].'\'')
            ->whereRaw('libro_ventas.ANO_LVENTA = \''.$datos['periodo'].'\'')
            ->whereRaw('libro_ventas.mes = \''.$datos['mes'].'\'')
            ->get();

        return response()->json($datos);
    }
}
