<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Traits\Autenticable;
use DB;
use Logger;
use App\Models\Producto;


class ProductoController extends Controller
{
    use Autenticable;

    public function index(Request $request)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');

        //$rango_inicio = $request->rango_inicio;
        //$cantidad = $request->cantidad;

        if($datos['rango_inicio'] ?? false) {
            $rango_inicio = $datos['rango_inicio'];
        } else {
            $rango_inicio = 0;
        }
        if($datos['cantidad'] ?? false) {
            $cantidad = $datos['cantidad'];
        } else {
            $cantidad = 10000000;
        }


        $limit = '';
        //dd($rango_inicio);

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        //nombre unidad medida
        $umedidas = DB::table('umedida')
        ->select(
            'ID_UMEDIDA as id',
            'NOMBRE_UMEDIDA as nombre',
            'NOMBRE as sigla'
        )
        //->whereRaw('ID_UMEDIDA = \''.$p->unidad_medida.'\'')
        ->get();
        $listaUnidadMedida = array();
        foreach($umedidas as $umedida){
            
            $listaUnidadMedida[$umedida->id] = $umedida->nombre;

        }
        


        $productos = DB::table('productos')
            ->select(
                'productos.CODIGO_PRODUCTO as codigo',
                'productos.CODIGOP_PRODUCTO as codigo_proveedor',
                'productos.CODIGO_BARRA as codigo_barra',
                'productos.DESCRIPCION_PRODUCTO as nombre',
                'productos.COSTO_REPOSICION as costo_maestro',
                'productos.VALOR_PRODUCTO as precio',
                'productos.EXENTO_PRODUCTO as exento',
                'productos.PRECIO_OFERTA as precio_oferta',
                'productos.FECHA_OFERTA as fecha_oferta',
                'productos.ESTADO_PRODUCTO as estado',
                'productos.ID_UMEDIDA as unidad_medida',
                'productos.INV_PRODUCTO as tipo_producto_id',
                'productos.ID_UMEDIDA as unidad_medida_id',
                'productos.PESO_PRODUCTO as peso',
                'productos.altura as altura',
                'productos.ancho as ancho',
                'productos.longitud as longitud',
                'productos.ID_LINEAPRODUCTO as linea_id',
                'productos.ID_FAMILIAFAMILIA as familia_id',
                'productos.ID_FAMILIAPRODUCTO as sub_familia_id',
                'productos.id_marca as marca_id',
                DB::raw('(COALESCE((SELECT SUM(CANTIDAD_DOC)
                    FROM detalle_inv_productos
                    WHERE
                        detalle_inv_productos.TIPO_MOV = 1
                        AND `detalle_inv_productos`.`CODIGO_PRODUCTO` = `productos`.`CODIGO_PRODUCTO`
                        AND `detalle_inv_productos`.`RUT_EMPRESA` = `productos`.`ID_EMPRESA`
                    GROUP BY `detalle_inv_productos`.`CODIGO_PRODUCTO`), 0))
                    -
                    (COALESCE((SELECT SUM(CANTIDAD_DOC)
                        FROM detalle_inv_productos
                        WHERE
                            detalle_inv_productos.TIPO_MOV = 2
                            AND `detalle_inv_productos`.`CODIGO_PRODUCTO` = `productos`.`CODIGO_PRODUCTO`
                            AND `detalle_inv_productos`.`RUT_EMPRESA` = `productos`.`ID_EMPRESA`
                        GROUP BY `detalle_inv_productos`.`CODIGO_PRODUCTO`), 0)) as stock')
            )
            ->whereRaw('productos.ID_EMPRESA = \''.$usuario->rut_empresa.'\'')
            ->whereRaw('productos.ESTADO_PRODUCTO in(1,2)')
            ->leftJoin('detalle_inv_productos AS entrada', function ($join) {
                $join->on('entrada.CODIGO_PRODUCTO', '=', 'productos.CODIGO_PRODUCTO');
                $join->on('entrada.RUT_EMPRESA', '=', 'productos.ID_EMPRESA');
                $join->where('entrada.TIPO_MOV', '=', '1');
            })
            ->leftJoin('detalle_inv_productos AS salida', function ($join) {
                $join->on('salida.CODIGO_PRODUCTO', '=', 'productos.CODIGO_PRODUCTO');
                $join->on('salida.RUT_EMPRESA', '=', 'productos.ID_EMPRESA');
                $join->where('salida.TIPO_MOV', '=', '2');
            })
            ->groupBy('productos.CODIGO_PRODUCTO')
            ->skip($rango_inicio)->take($cantidad)
            ->get();

            
        foreach($productos as $p){
            
            if(!empty($p->unidad_medida)){
                $p->unidad_medida = $listaUnidadMedida[$p->unidad_medida];
            }
            
            if(is_null($p->stock)) {
                $p->stock = 0;
            }

            if(is_null($p->exento)) {
                $p->exento = 0;
            }
            if(is_null($p->precio)) {
                $p->precio = 0;
            }
            if(is_null($p->fecha_oferta)) {
                $p->fecha_oferta = "";
            }
            if(is_null($p->precio_oferta)) {
                $p->precio_oferta = "0";
            }
        }

        Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            '',
            json_encode($productos),
            ENV('AMBIENTE_SII'),
            $request->ip()
        );

        return response()->json($productos);

    }

    



    public function maestro(Request $request)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');

        //$rango_inicio = $request->rango_inicio;
        //$cantidad = $request->cantidad;

        if($datos['rango_inicio'] ?? false) {
            $rango_inicio = $datos['rango_inicio'];
        } else {
            $rango_inicio = 0;
        }
        if($datos['cantidad'] ?? false) {
            $cantidad = $datos['cantidad'];
        } else {
            $cantidad = 10000000;
        }


        $limit = '';
        //dd($rango_inicio);

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        //nombre unidad medida
        $umedidas = DB::table('umedida')
        ->select(
            'ID_UMEDIDA as id',
            'NOMBRE_UMEDIDA as nombre',
            'NOMBRE as sigla'
        )
        //->whereRaw('ID_UMEDIDA = \''.$p->unidad_medida.'\'')
        ->get();
        $listaUnidadMedida = array();
        foreach($umedidas as $umedida){
            
            $listaUnidadMedida[$umedida->id] = $umedida->nombre;

        }
        


        $productos = DB::table('productos')
            ->select(
                'productos.CODIGO_PRODUCTO as codigo',
                'productos.CODIGOP_PRODUCTO as codigo_proveedor',
                'productos.CODIGO_BARRA as codigo_barra',
                'productos.DESCRIPCION_PRODUCTO as nombre',
                'productos.COSTO_REPOSICION as costo_maestro',
                'productos.VALOR_PRODUCTO as precio',
                'productos.EXENTO_PRODUCTO as exento',
                'productos.PRECIO_OFERTA as precio_oferta',
                'productos.FECHA_OFERTA as fecha_oferta',
                'productos.ESTADO_PRODUCTO as estado',
                'productos.ID_UMEDIDA as unidad_medida',
                'productos.INV_PRODUCTO as tipo_producto_id',
                'productos.ID_UMEDIDA as unidad_medida_id',
                'productos.PESO_PRODUCTO as peso',
                'productos.altura as altura',
                'productos.ancho as ancho',
                'productos.longitud as longitud',
                'productos.ID_LINEAPRODUCTO as linea_id',
                'productos.ID_FAMILIAFAMILIA as familia_id',
                'productos.ID_FAMILIAPRODUCTO as sub_familia_id',
                'productos.id_marca as marca_id'
            )
            ->whereRaw('productos.ID_EMPRESA = \''.$usuario->rut_empresa.'\'')
            ->whereRaw('productos.ESTADO_PRODUCTO in(1,2)')
            ->groupBy('productos.CODIGO_PRODUCTO')
            ->skip($rango_inicio)->take($cantidad)
            ->get();

            
        foreach($productos as $p){
            
            if(!empty($p->unidad_medida)){
                $p->unidad_medida = $listaUnidadMedida[$p->unidad_medida];
            }
            
            if(is_null($p->exento)) {
                $p->exento = 0;
            }
            if(is_null($p->precio)) {
                $p->precio = 0;
            }
            if(is_null($p->fecha_oferta)) {
                $p->fecha_oferta = "";
            }
            if(is_null($p->precio_oferta)) {
                $p->precio_oferta = "0";
            }
        }

        Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            '',
            json_encode($productos),
            ENV('AMBIENTE_SII'),
            $request->ip()
        );

        return response()->json($productos);

    }

    public function productoActivos(Request $request)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');

        //$rango_inicio = $request->rango_inicio;
        //$cantidad = $request->cantidad;

        if($datos['rango_inicio'] ?? false) {
            $rango_inicio = $datos['rango_inicio'];
        } else {
            $rango_inicio = 0;
        }
        if($datos['cantidad'] ?? false) {
            $cantidad = $datos['cantidad'];
        } else {
            $cantidad = 10000000;
        }


        $limit = '';
        //dd($rango_inicio);

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }



        $productos = DB::table('productos')
            ->select(
                'productos.CODIGO_PRODUCTO as codigo',
                'productos.CODIGOP_PRODUCTO as codigo_proveedor',
                'productos.CODIGO_BARRA as codigo_barra',
                'productos.DESCRIPCION_PRODUCTO as nombre',
                'productos.COSTO_REPOSICION as costo_maestro',
                'productos.VALOR_PRODUCTO as precio',
                'productos.EXENTO_PRODUCTO as exento',
                'productos.PRECIO_OFERTA as precio_oferta',
                'productos.FECHA_OFERTA as fecha_oferta',
                'productos.ESTADO_PRODUCTO as estado',
                'productos.INV_PRODUCTO as tipo_producto_id',
                'productos.ID_UMEDIDA as unidad_medida_id',
                'productos.PESO_PRODUCTO as peso',
                'productos.altura as altura',
                'productos.ancho as ancho',
                'productos.longitud as longitud',
                'productos.ID_LINEAPRODUCTO as linea_id',
                'productos.ID_FAMILIAFAMILIA as familia_id',
                'productos.ID_FAMILIAPRODUCTO as sub_familia_id',
                'productos.id_marca as marca_id',
            
                DB::raw('(COALESCE((SELECT SUM(CANTIDAD_DOC)
                    FROM detalle_inv_productos
                    WHERE
                        detalle_inv_productos.TIPO_MOV = 1
                        AND `detalle_inv_productos`.`CODIGO_PRODUCTO` = `productos`.`CODIGO_PRODUCTO`
                        AND `detalle_inv_productos`.`RUT_EMPRESA` = `productos`.`ID_EMPRESA`
                    GROUP BY `detalle_inv_productos`.`CODIGO_PRODUCTO`), 0))
                    -
                    (COALESCE((SELECT SUM(CANTIDAD_DOC)
                        FROM detalle_inv_productos
                        WHERE
                            detalle_inv_productos.TIPO_MOV = 2
                            AND `detalle_inv_productos`.`CODIGO_PRODUCTO` = `productos`.`CODIGO_PRODUCTO`
                            AND `detalle_inv_productos`.`RUT_EMPRESA` = `productos`.`ID_EMPRESA`
                        GROUP BY `detalle_inv_productos`.`CODIGO_PRODUCTO`), 0)) as stock')
            )
            ->whereRaw('productos.ID_EMPRESA = \''.$usuario->rut_empresa.'\'')
            ->whereRaw('productos.ESTADO_PRODUCTO = 1')
            ->leftJoin('detalle_inv_productos AS entrada', function ($join) {
                $join->on('entrada.CODIGO_PRODUCTO', '=', 'productos.CODIGO_PRODUCTO');
                $join->on('entrada.RUT_EMPRESA', '=', 'productos.ID_EMPRESA');
                $join->where('entrada.TIPO_MOV', '=', '1');
            })
            ->leftJoin('detalle_inv_productos AS salida', function ($join) {
                $join->on('salida.CODIGO_PRODUCTO', '=', 'productos.CODIGO_PRODUCTO');
                $join->on('salida.RUT_EMPRESA', '=', 'productos.ID_EMPRESA');
                $join->where('salida.TIPO_MOV', '=', '2');
            })
            ->groupBy('productos.CODIGO_PRODUCTO')
            ->skip($rango_inicio)->take($cantidad)
            ->get();

        foreach($productos as $p){
            if(is_null($p->stock)) {
                $p->stock = 0;
            }

            if(is_null($p->exento)) {
                $p->exento = 0;
            }
            if(is_null($p->precio)) {
                $p->precio = 0;
            }
            if(is_null($p->fecha_oferta)) {
                $p->fecha_oferta = "";
            }
            if(is_null($p->precio_oferta)) {
                $p->precio_oferta = "0";
            }
        }

        Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            '',
            json_encode($productos),
            ENV('AMBIENTE_SII'),
            $request->ip()
        );

        return response()->json($productos);

    }

    public function productoActivos2(Request $request)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');

        //$rango_inicio = $request->rango_inicio;
        //$cantidad = $request->cantidad;

        if($datos['rango_inicio'] ?? false) {
            $rango_inicio = $datos['rango_inicio'];
        } else {
            $rango_inicio = 0;
        }
        if($datos['cantidad'] ?? false) {
            $cantidad = $datos['cantidad'];
        } else {
            $cantidad = 10000000;
        }


        $limit = '';
        //dd($rango_inicio);

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $listaStock = array();
        $stock_cierre = DB::table('detalle_inv1_cierre')
            ->select('codigo','stock')
            ->whereRaw('rut_empresa = \''.$usuario->rut_empresa.'\'')
            //->where('codigo','=','32790-07500-2')
            ->groupBy('codigo')
            ->get();
        foreach($stock_cierre as $stock){
            $listaStock[$stock->codigo] = $stock->stock;
        }
        
        $andFecha = 'AND detalle_inv_productos.FECHA_MOV >= "2023-01-01"';

        $productos = DB::table('productos')
            ->select(
                'productos.CODIGO_PRODUCTO as codigo',
                'productos.CODIGOP_PRODUCTO as codigo_proveedor',
                'productos.CODIGO_BARRA as codigo_barra',
                'productos.DESCRIPCION_PRODUCTO as nombre',
                'productos.COSTO_REPOSICION as costo_maestro',
                'productos.VALOR_PRODUCTO as precio',
                'productos.EXENTO_PRODUCTO as exento',
                'productos.PRECIO_OFERTA as precio_oferta',
                'productos.FECHA_OFERTA as fecha_oferta',
                'productos.ESTADO_PRODUCTO as estado',
                'productos.INV_PRODUCTO as tipo_producto_id',
                'productos.ID_UMEDIDA as unidad_medida_id',
                'productos.PESO_PRODUCTO as peso',
                'productos.altura as altura',
                'productos.ancho as ancho',
                'productos.longitud as longitud',
                'productos.ID_LINEAPRODUCTO as linea_id',
                'productos.ID_FAMILIAFAMILIA as familia_id',
                'productos.ID_FAMILIAPRODUCTO as sub_familia_id',
                'productos.id_marca as marca_id',
                
                DB::raw('(COALESCE((SELECT SUM(CANTIDAD_DOC)
                    FROM detalle_inv_productos
                    WHERE
                        detalle_inv_productos.TIPO_MOV = 1
                        AND `detalle_inv_productos`.`CODIGO_PRODUCTO` = `productos`.`CODIGO_PRODUCTO`
                        AND `detalle_inv_productos`.`RUT_EMPRESA` = `productos`.`ID_EMPRESA`
                        '.$andFecha.'
                    GROUP BY `detalle_inv_productos`.`CODIGO_PRODUCTO`), 0))
                    -
                    (COALESCE((SELECT SUM(CANTIDAD_DOC)
                        FROM detalle_inv_productos
                        WHERE
                            detalle_inv_productos.TIPO_MOV = 2
                            AND `detalle_inv_productos`.`CODIGO_PRODUCTO` = `productos`.`CODIGO_PRODUCTO`
                            AND `detalle_inv_productos`.`RUT_EMPRESA` = `productos`.`ID_EMPRESA`
                            '.$andFecha.'
                        GROUP BY `detalle_inv_productos`.`CODIGO_PRODUCTO`), 0)) as stock')
            )
            ->whereRaw('productos.ID_EMPRESA = \''.$usuario->rut_empresa.'\'')
            ->whereRaw('productos.ESTADO_PRODUCTO = 1')
            ->leftJoin('detalle_inv_productos AS entrada', function ($join) {
                $join->on('entrada.CODIGO_PRODUCTO', '=', 'productos.CODIGO_PRODUCTO');
                $join->on('entrada.RUT_EMPRESA', '=', 'productos.ID_EMPRESA');
                $join->where('entrada.TIPO_MOV', '=', '1');
                $join->where('entrada.FECHA_MOV', '>=', '2023-01-01');
            })
            ->leftJoin('detalle_inv_productos AS salida', function ($join) {
                $join->on('salida.CODIGO_PRODUCTO', '=', 'productos.CODIGO_PRODUCTO');
                $join->on('salida.RUT_EMPRESA', '=', 'productos.ID_EMPRESA');
                $join->where('salida.TIPO_MOV', '=', '2');
                $join->where('salida.FECHA_MOV', '>=', '2023-01-01');
            })
            ->groupBy('productos.CODIGO_PRODUCTO')
            ->skip($rango_inicio)->take($cantidad)
            ->get();
        
        foreach($productos as $p){
            if(is_null($p->stock)) {
                $p->stock = 0;
            }else{
                
                $stock_cierre = 0;
                if (!empty($listaStock[$p->codigo])) {
                    $stock_cierre = $listaStock[$p->codigo];
                }
                
                
                $p->stock = $p->stock + $stock_cierre ;
            }

            
            if(is_null($p->exento)) {
                $p->exento = 0;
            }
            if(is_null($p->precio)) {
                $p->precio = 0;
            }
            if(is_null($p->fecha_oferta)) {
                $p->fecha_oferta = "";
            }
            if(is_null($p->precio_oferta)) {
                $p->precio_oferta = "0";
            }
            
        }

        Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            '',
            json_encode($productos),
            ENV('AMBIENTE_SII'),
            $request->ip()
        );

        return response()->json($productos);

    }

    public function productoActivos3(Request $request)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');

        //$rango_inicio = $request->rango_inicio;
        //$cantidad = $request->cantidad;

        if($datos['rango_inicio'] ?? false) {
            $rango_inicio = $datos['rango_inicio'];
        } else {
            $rango_inicio = 0;
        }
        if($datos['cantidad'] ?? false) {
            $cantidad = $datos['cantidad'];
        } else {
            $cantidad = 10000000;
        }


        $limit = '';
        //dd($rango_inicio);

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $listaStock = array();
        $stock_cierre = DB::table('detalle_inv1_cierre2')
            ->select('codigo','stock')
            ->whereRaw('rut_empresa = \''.$usuario->rut_empresa.'\'')
            //->where('codigo','=','32790-07500-2')
            ->groupBy('codigo')
            ->get();
        foreach($stock_cierre as $stock){
            $listaStock[$stock->codigo] = $stock->stock;
        }
        
        $andFecha = 'AND detalle_inv_productos.FECHA_MOV >= "2023-01-01"';

        $productos = DB::table('productos')
            ->select(
                'productos.CODIGO_PRODUCTO as codigo',
                'productos.CODIGOP_PRODUCTO as codigo_proveedor',
                'productos.CODIGO_BARRA as codigo_barra',
                'productos.DESCRIPCION_PRODUCTO as nombre',
                'productos.COSTO_REPOSICION as costo_maestro',
                'productos.VALOR_PRODUCTO as precio',
                'productos.EXENTO_PRODUCTO as exento',
                'productos.PRECIO_OFERTA as precio_oferta',
                'productos.FECHA_OFERTA as fecha_oferta',
                'productos.ESTADO_PRODUCTO as estado',
                'productos.INV_PRODUCTO as tipo_producto_id',
                'productos.ID_UMEDIDA as unidad_medida_id',
                'productos.PESO_PRODUCTO as peso',
                'productos.altura as altura',
                'productos.ancho as ancho',
                'productos.longitud as longitud',
                'productos.ID_LINEAPRODUCTO as linea_id',
                'productos.ID_FAMILIAFAMILIA as familia_id',
                'productos.ID_FAMILIAPRODUCTO as sub_familia_id',
                'productos.id_marca as marca_id',
                
                DB::raw('(COALESCE((SELECT SUM(CANTIDAD_DOC)
                    FROM detalle_inv_productos
                    WHERE
                        detalle_inv_productos.TIPO_MOV = 1
                        AND `detalle_inv_productos`.`CODIGO_PRODUCTO` = `productos`.`CODIGO_PRODUCTO`
                        AND `detalle_inv_productos`.`RUT_EMPRESA` = `productos`.`ID_EMPRESA`
                        '.$andFecha.'
                    GROUP BY `detalle_inv_productos`.`CODIGO_PRODUCTO`), 0))
                    -
                    (COALESCE((SELECT SUM(CANTIDAD_DOC)
                        FROM detalle_inv_productos
                        WHERE
                            detalle_inv_productos.TIPO_MOV = 2
                            AND `detalle_inv_productos`.`CODIGO_PRODUCTO` = `productos`.`CODIGO_PRODUCTO`
                            AND `detalle_inv_productos`.`RUT_EMPRESA` = `productos`.`ID_EMPRESA`
                            '.$andFecha.'
                        GROUP BY `detalle_inv_productos`.`CODIGO_PRODUCTO`), 0)) as stock')
            )
            ->whereRaw('productos.ID_EMPRESA = \''.$usuario->rut_empresa.'\'')
            ->whereRaw('productos.ESTADO_PRODUCTO = 1')
            ->leftJoin('detalle_inv_productos AS entrada', function ($join) {
                $join->on('entrada.CODIGO_PRODUCTO', '=', 'productos.CODIGO_PRODUCTO');
                $join->on('entrada.RUT_EMPRESA', '=', 'productos.ID_EMPRESA');
                $join->where('entrada.TIPO_MOV', '=', '1');
                $join->where('entrada.FECHA_MOV', '>=', '2023-01-01');
            })
            ->leftJoin('detalle_inv_productos AS salida', function ($join) {
                $join->on('salida.CODIGO_PRODUCTO', '=', 'productos.CODIGO_PRODUCTO');
                $join->on('salida.RUT_EMPRESA', '=', 'productos.ID_EMPRESA');
                $join->where('salida.TIPO_MOV', '=', '2');
                $join->where('salida.FECHA_MOV', '>=', '2023-01-01');
            })
            ->groupBy('productos.CODIGO_PRODUCTO')
            ->skip($rango_inicio)->take($cantidad)
            ->get();
        
        foreach($productos as $p){
            if(is_null($p->stock)) {
                $p->stock = 0;
            }else{
                
                $stock_cierre = 0;
                if (!empty($listaStock[$p->codigo])) {
                    $stock_cierre = $listaStock[$p->codigo];
                }
                
                
                $p->stock = $p->stock + $stock_cierre ;
            }

            
            if(is_null($p->exento)) {
                $p->exento = 0;
            }
            if(is_null($p->precio)) {
                $p->precio = 0;
            }
            if(is_null($p->fecha_oferta)) {
                $p->fecha_oferta = "";
            }
            if(is_null($p->precio_oferta)) {
                $p->precio_oferta = "0";
            }
            
        }

        Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            '',
            json_encode($productos),
            ENV('AMBIENTE_SII'),
            $request->ip()
        );

        return response()->json($productos);

    }

    public function getProducto(Request $request,$codigo)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');


        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $productos = DB::table('productos')
            ->select(
                'productos.CODIGO_PRODUCTO as codigo',
                'productos.CODIGOP_PRODUCTO as codigo_proveedor',
                'productos.DESCRIPCION_PRODUCTO as nombre',
                'productos.VALOR_PRODUCTO as precio',
                'productos.EXENTO_PRODUCTO as exento',
                'productos.PRECIO_OFERTA as precio_oferta',
                'productos.FECHA_OFERTA as fecha_oferta',
                'productos.ESTADO_PRODUCTO as estado',
                'productos.INV_PRODUCTO as tipo_producto_id',
                'productos.ID_UMEDIDA as unidad_medida_id',
                'productos.PESO_PRODUCTO as peso',
                'productos.altura as altura',
                'productos.ancho as ancho',
                'productos.longitud as longitud',
                'productos.ID_LINEAPRODUCTO as linea_id',
                'productos.ID_FAMILIAFAMILIA as familia_id',
                'productos.ID_FAMILIAPRODUCTO as sub_familia_id',
                'productos.id_marca as marca_id',
                DB::raw('(COALESCE((SELECT SUM(CANTIDAD_DOC)
                    FROM detalle_inv_productos
                    WHERE
                        detalle_inv_productos.TIPO_MOV = 1
                        AND `detalle_inv_productos`.`CODIGO_PRODUCTO` = `productos`.`CODIGO_PRODUCTO`
                        AND `detalle_inv_productos`.`RUT_EMPRESA` = `productos`.`ID_EMPRESA`
                    GROUP BY `detalle_inv_productos`.`CODIGO_PRODUCTO`), 0))
                    -
                    (COALESCE((SELECT SUM(CANTIDAD_DOC)
                        FROM detalle_inv_productos
                        WHERE
                            detalle_inv_productos.TIPO_MOV = 2
                            AND `detalle_inv_productos`.`CODIGO_PRODUCTO` = `productos`.`CODIGO_PRODUCTO`
                            AND `detalle_inv_productos`.`RUT_EMPRESA` = `productos`.`ID_EMPRESA`
                        GROUP BY `detalle_inv_productos`.`CODIGO_PRODUCTO`), 0)) as stock')
            )
            ->whereRaw('productos.ID_EMPRESA = \''.$usuario->rut_empresa.'\'')
            ->whereRaw('productos.CODIGO_PRODUCTO = \''.$codigo.'\'')
            ->leftJoin('detalle_inv_productos AS entrada', function ($join) {
                $join->on('entrada.CODIGO_PRODUCTO', '=', 'productos.CODIGO_PRODUCTO');
                $join->on('entrada.RUT_EMPRESA', '=', 'productos.ID_EMPRESA');
                $join->where('entrada.TIPO_MOV', '=', '1');
            })
            ->leftJoin('detalle_inv_productos AS salida', function ($join) {
                $join->on('salida.CODIGO_PRODUCTO', '=', 'productos.CODIGO_PRODUCTO');
                $join->on('salida.RUT_EMPRESA', '=', 'productos.ID_EMPRESA');
                $join->where('salida.TIPO_MOV', '=', '2');
            })
            ->groupBy('productos.CODIGO_PRODUCTO')
            ->get();

        foreach($productos as $p){
            if(is_null($p->stock)) {
                $p->stock = 0;
            }

            if(is_null($p->exento)) {
                $p->exento = 0;
            }
            if(is_null($p->precio)) {
                $p->precio = 0;
            }
            if(is_null($p->fecha_oferta)) {
                $p->fecha_oferta = "";
            }
            if(is_null($p->precio_oferta)) {
                $p->precio_oferta = "0";
            }
        }

        Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            '',
            json_encode($productos),
            ENV('AMBIENTE_SII'),
            $request->ip()
        );

        return response()->json($productos);

    }


    public function ingresar(Request $request)
    {
        $datos = $request->json()->all();

        $token = is_null($request->header('token')) ? $datos['token'] : $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $respuesta = [];

        Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            $datos,
            $respuesta,
            ENV('AMBIENTE_SII'),
            $request->ip()
        );

        try {
            //dd($datos['productos']);
            foreach ($datos['productos'] as $producto) {
                //dd($producto);
                try {
                    //dd($producto);
                    $this->validateArray($request, $producto, [
                        'codigo' => 'required|min:3|max:100',
                        'codigo_proveedor' => 'sometimes|required|min:3|max:100',
                        'nombre' => 'required|min:5|max:100',
                        'tipo_producto_id' => 'required|max:100',
                        'unidad_medida_id' => 'required|max:100',
                        'estado' => 'required|integer|in:0,1',
                        'precio' => 'required|integer|min:0',
                        'exento' => 'sometimes|required|integer|in:0,1',
                        'linea_id' => 'required|integer|min:0',
                        'familia_id' => 'required|integer|min:0',
                        'sub_familia_id' => 'required|integer|min:0'
                    ]);
                } catch (ValidationException $e) {
                    dd($e);
                    $respuesta[] = [$producto['codigo'] => (array) $e->getResponse()->getData()];

                    //continue;
                }



                $producto_existe = Producto::obtenProducto($producto['codigo'], $usuario->rut_empresa);
                if (!is_null($producto_existe)) {
                    $respuesta[] = [$producto['codigo'] => ['mensaje' => 'Producto '.$producto['codigo'].' ya registrado.']];
                    continue;
                }

                //verifica que exista tipo de producto
                $tipoproducto = Producto::obtenTipoProducto($producto['tipo_producto_id']);
                //dd($tipoproducto);
                if (empty($tipoproducto)) {
                    $respuesta[] = [$producto['codigo'] => ['mensaje' => 'Tipo de producto '.$producto['tipo_producto_id'].' NO existe.']];
                    continue;
                }
                //verifica que exista unidad de medida
                $unidadmedida = Producto::obtenUnidadMedida($producto['unidad_medida_id']);
                //dd($tipoproducto);
                if (empty($unidadmedida)) {
                    $respuesta[] = [$producto['codigo'] => ['mensaje' => 'Unidad de medida '.$producto['unidad_medida_id'].' NO existe.']];
                    continue;
                }
                //verifica que exista linea de producto

                $lineas = Producto::obtenLineas($producto['linea_id'], $usuario->rut_empresa);
                //dd($tipoproducto);
                if (empty($lineas)) {
                    $respuesta[] = [$producto['codigo'] => ['mensaje' => 'Linea '.$producto['linea_id'].' NO existe.']];
                    continue;
                }
                $familias = Producto::obtenfamilia($producto['familia_id'], $usuario->rut_empresa);
                //dd($tipoproducto);
                if (empty($familias)) {
                    $respuesta[] = [$producto['codigo'] => ['mensaje' => 'Familia_id '.$producto['familia_id'].' NO existe.']];
                    continue;
                }
                $subfamilias = Producto::obtenSubfamilia($producto['sub_familia_id'], $usuario->rut_empresa);

                if (empty($subfamilias)) {
                    $respuesta[] = [$producto['codigo'] => ['mensaje' => 'Sub_Familia_id '.$producto['sub_familia_id'].' NO existe.']];
                    continue;
                }
                //dd($producto);
                //dd("paso validacion");
                //DB::beginTransaction();
                $resultado = DB::table('productos')
                    ->insert([
                        'ID_EMPRESA' => $usuario->rut_empresa,
                        'CODIGO_PRODUCTO' => $producto['codigo'],
                        'CODIGOP_PRODUCTO' => isset($producto['codigo_proveedor']) ? $producto['codigo_proveedor'] : '',
                        'CODIGO_BARRA' => $producto['codigo_barra'],
                        'ID_FAMILIAFAMILIA' => $producto['familia_id'],
                        'ID_FAMILIAPRODUCTO' => $producto['sub_familia_id'],
                        //'ID_SEGMENTO'
                        //STOCKMIN_PRODUCTO
                        //STOCKMAX_PRODUCTO
                        'DESCRIPCION_PRODUCTO'  => $producto['nombre'],
                        'VALOR_PRODUCTO' => $producto['precio'],
                        //CENTROC_PRODUCTO
                        'ID_UMEDIDA' => $producto['unidad_medida_id'],
                        //FORMATO_VENTA
                        'EXENTO_PRODUCTO' => $producto['exento'],
                        //ANEGOCIO_PRODUCTO
                        'INV_PRODUCTO' => $producto['tipo_producto_id'],
                        //VALOR_INV_PRODUCTO
                        //PRODUCTO_IMAGEN
                        //WEB_ESTADO
                        'ESTADO_PRODUCTO' => $producto['estado'],
                        //DETALLE_LARGO
                        //ESPECIFICACIONES
                        //MARGEN
                        //PORCENTAJE
                        //COSTO_REPOSICION
                        //COMIS_ESPE
                        //DESTACADO_PRODUCTO
                        'ID_LINEAPRODUCTO' => $producto['linea_id'],
                        //UBICACION_PRODUCTO
                        //DESCRIPCION_INGLES
                        //PRECIO2
                        //PRECIO_OFERTA
                        //FECHA_OFERTA
                        //PESO_PRODUCTO
                        //DESTACADO
                        //NUEVO
                        //FNUEVO
                        //IP_MERMA
                        //VIDEO
                        //IMPYRECA
                        //PROD_IMPYRECA
                        //ID_SUCURSAL
                        //ID_ORIGEN
                        //ID_DESTINO
                        //NO_FACTURABLE
                        //codigo_variable
                        //markup
                        //id_marca
                    ]);

                if (!$resultado) {
                    $respuesta[] = [$producto['codigo'] => ['mensaje' => 'Producto no pudo ser ingresado']];
                    DB::rollback();
                    continue;
                }




                // Commit the transaction
                //DB::commit();

                $respuesta[] = [$producto['codigo'] => ['mensaje' => 'Producto ingresado con exito.']];
            }
        } catch (\Exception $e) {
            //DB::rollback();
            //continue;
            //(array) $e->getResponse()->getData()
            //print_r($e->getResponse()->getData());
            dd("error: ".$e);
            $respuesta[] = ['Error' => ['mensaje' => 'Array de productos con datos incorrectos.']];

        }



        Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            json_encode(utf8_encode_recursivo((array)$request->all())),
            $respuesta,
            ENV('AMBIENTE_SII'),
            $request->ip()
        );

        return response()->json($respuesta);
    }

    public function actualizar(Request $request, $codigo)
    {
        $datos = $request->json()->all();

        $token = is_null($request->header('token')) ? $datos['token'] : $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $respuesta = [];

        
            
        try {
            //dd($producto);
            $this->validate($request, [
                'codigo_proveedor' => 'sometimes|required|min:3|max:100',
                'nombre' => 'sometimes|required|min:5|max:100',
                'tipo_producto_id' => 'sometimes|required|max:100',
                'unidad_medida_id' => 'sometimes|required|max:100',
                'estado' => 'sometimes|required|integer|in:1,2',
                'precio' => 'sometimes|required|integer|min:0',
                'exento' => 'sometimes|required|integer|in:0,1',
                'linea_id' => 'sometimes|required|integer|min:0',
                'familia_id' => 'sometimes|required|integer|min:0',
                'sub_familia_id' => 'sometimes|required|integer|min:0'
            ]);
        } catch (ValidationException $e) {
            $respuesta[] = [$rut => (array) $e->getResponse()->getData()];
            return response()->json($respuesta);
        }
        
        $producto = Producto::obtenProducto($codigo, $usuario->rut_empresa);
        if (is_null($producto)) {
            $respuesta[] = [$codigo => ['mensaje' => 'Producto '.$codigo.' NO registrado.']];
            return response()->json($respuesta);
        }

        //verifica que exista tipo de producto
        $tipoproducto = isset($datos['tipo_producto_id']) ? $datos['tipo_producto_id'] : $producto->INV_PRODUCTO;
        if (is_null($tipoproducto)) {
            $respuesta[] = [$codigo => ['mensaje' => 'Tipo de producto NO existe.']];
                return response()->json($respuesta);
        }

        
        //verifica que exista unidad de medida
        $unidadmedida = isset($datos['unidad_medida_id']) ? $datos['unidad_medida_id'] : $producto->ID_UMEDIDA;
        if (is_null($unidadmedida)) {
            $respuesta[] = [$codigo => ['mensaje' => 'Unidad de medida NO existe.']];
            return response()->json($respuesta);
        }
                
        $lineas = isset($datos['linea_id']) ? $datos['linea_id'] : $producto->ID_LINEAPRODUCTO;
        if (is_null($lineas)) {
            $respuesta[] = [$codigo => ['mensaje' => 'Linea de producto NO existe.']];
            return response()->json($respuesta);
        }
        
        
        $familias = isset($datos['familia_id']) ? $datos['familia_id'] : $producto->ID_FAMILIAFAMILIA;
        if (is_null($familias)) {
            $respuesta[] = [$codigo => ['mensaje' => 'Familia de producto NO existe.']];
            return response()->json($respuesta);
        }

        $subfamilias = isset($datos['sub_familia_id']) ? $datos['sub_familia_id'] : $producto->ID_FAMILIAPRODUCTO;
        if (is_null($familias)) {
            $respuesta[] = [$codigo => ['mensaje' => 'Sub-Familia de producto NO existe.']];
            return response()->json($respuesta);
        }
        
        
        $resultado = DB::table('productos')
            ->whereRaw('CODIGO_PRODUCTO = \''.$codigo.'\'')
            ->whereRaw('ID_EMPRESA = \''.$usuario->rut_empresa.'\'')
            ->update([
                'CODIGOP_PRODUCTO' => isset($datos['codigo_proveedor']) ? $datos['codigo_proveedor'] : $producto->CODIGOP_PRODUCTO,
                'CODIGO_BARRA' => isset($datos['codigo_barra']) ? $datos['codigo_barra']:$producto->CODIGO_BARRA,
                'ID_FAMILIAFAMILIA' => isset($datos['familia_id']) ? $datos['familia_id']:$producto->ID_FAMILIAFAMILIA,
                'ID_FAMILIAPRODUCTO' => isset($datos['sub_familia_id']) ? $datos['sub_familia_id']:$producto->ID_FAMILIAPRODUCTO,
                //'ID_SEGMENTO'
                //STOCKMIN_PRODUCTO
                //STOCKMAX_PRODUCTO
                'DESCRIPCION_PRODUCTO'  => isset($datos['nombre']) ? $datos['nombre']:$producto->DESCRIPCION_PRODUCTO,
                'VALOR_PRODUCTO' => isset($datos['precio']) ? $datos['precio']:$producto->VALOR_PRODUCTO,
                //CENTROC_PRODUCTO
                'ID_UMEDIDA' => isset($datos['unidad_medida_id']) ? $datos['unidad_medida_id']:$producto->ID_UMEDIDA,
                //FORMATO_VENTA
                'EXENTO_PRODUCTO' => isset($datos['exento']) ? $datos['exento']:$producto->EXENTO_PRODUCTO,
                //ANEGOCIO_PRODUCTO
                'INV_PRODUCTO' => isset($datos['tipo_producto_id']) ? $datos['tipo_producto_id']:$producto->INV_PRODUCTO,
                //VALOR_INV_PRODUCTO
                //PRODUCTO_IMAGEN
                //WEB_ESTADO
                'ESTADO_PRODUCTO' => isset($datos['estado']) ? $datos['estado']:$producto->ESTADO_PRODUCTO,
                //DETALLE_LARGO
                //ESPECIFICACIONES
                //MARGEN
                //PORCENTAJE
                //COSTO_REPOSICION
                //COMIS_ESPE
                //DESTACADO_PRODUCTO
                'ID_LINEAPRODUCTO' => isset($datos['linea_id']) ? $datos['linea_id']:$producto->ID_LINEAPRODUCTO,
                //UBICACION_PRODUCTO
                //DESCRIPCION_INGLES
                //PRECIO2
                //PRECIO_OFERTA
                //FECHA_OFERTA
                //PESO_PRODUCTO
                //DESTACADO
                //NUEVO
                //FNUEVO
                //IP_MERMA
                //VIDEO
                //IMPYRECA
                //PROD_IMPYRECA
                //ID_SUCURSAL
                //ID_ORIGEN
                //ID_DESTINO
                //NO_FACTURABLE
                //codigo_variable
                //markup
                //id_marca
            ]);

        if (!$resultado) {
            $respuesta[] = [$codigo => ['mensaje' => 'Producto no fue actualizado']];
            DB::rollback();
            return response()->json($respuesta);
        }

        // Commit the transaction
        //DB::commit();

        $respuesta[] = [$codigo => ['mensaje' => 'Producto actualizado con exito.']];
            
        
        Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            json_encode(utf8_encode_recursivo((array)$request->all())),
            $respuesta,
            ENV('AMBIENTE_SII'),
            $request->ip()
        );

        return response()->json($respuesta);
    }


    public function productos_pack(Request $request)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $productos = DB::table('productos')
            ->select(
                'productos.CODIGO_PRODUCTO as codigo',
                'productos.CODIGOP_PRODUCTO as codigo_proveedor',
                'productos.DESCRIPCION_PRODUCTO as nombre',
                'productos.VALOR_PRODUCTO as precio',
                'productos.EXENTO_PRODUCTO as exento',
                'productos.PRECIO_OFERTA as precio_oferta',
                'productos.FECHA_OFERTA as fecha_oferta',
                'productos.ESTADO_PRODUCTO as estado',
                'productos.INV_PRODUCTO as tipo_producto_id',
                'productos.ID_UMEDIDA as unidad_medida_id',
                'productos.PESO_PRODUCTO as peso',
                'productos.altura as altura',
                'productos.ancho as ancho',
                'productos.longitud as longitud',
                'productos.ID_LINEAPRODUCTO as linea_id',
                'productos.ID_FAMILIAFAMILIA as familia_id',
                'productos.ID_FAMILIAPRODUCTO as sub_familia_id',
                'productos.id_marca as marca_id',
                DB::raw('(COALESCE((SELECT SUM(CANTIDAD_DOC)
                    FROM detalle_inv_productos
                    WHERE
                        detalle_inv_productos.TIPO_MOV = 1
                        AND `detalle_inv_productos`.`CODIGO_PRODUCTO` = `productos`.`CODIGO_PRODUCTO`
                        AND `detalle_inv_productos`.`RUT_EMPRESA` = `productos`.`ID_EMPRESA`
                    GROUP BY `detalle_inv_productos`.`CODIGO_PRODUCTO`), 0))
                    -
                    (COALESCE((SELECT SUM(CANTIDAD_DOC)
                        FROM detalle_inv_productos
                        WHERE
                            detalle_inv_productos.TIPO_MOV = 2
                            AND `detalle_inv_productos`.`CODIGO_PRODUCTO` = `productos`.`CODIGO_PRODUCTO`
                            AND `detalle_inv_productos`.`RUT_EMPRESA` = `productos`.`ID_EMPRESA`
                        GROUP BY `detalle_inv_productos`.`CODIGO_PRODUCTO`), 0)) as stock')
            )
            ->whereRaw('productos.ID_EMPRESA = \''.$usuario->rut_empresa.'\'')
            ->whereRaw('productos.INV_PRODUCTO = 14')
            ->leftJoin('detalle_inv_productos AS entrada', function ($join) {
                $join->on('entrada.CODIGO_PRODUCTO', '=', 'productos.CODIGO_PRODUCTO');
                $join->on('entrada.RUT_EMPRESA', '=', 'productos.ID_EMPRESA');
                $join->where('entrada.TIPO_MOV', '=', '1');
            })
            ->leftJoin('detalle_inv_productos AS salida', function ($join) {
                $join->on('salida.CODIGO_PRODUCTO', '=', 'productos.CODIGO_PRODUCTO');
                $join->on('salida.RUT_EMPRESA', '=', 'productos.ID_EMPRESA');
                $join->where('salida.TIPO_MOV', '=', '2');
            })
            ->groupBy('productos.CODIGO_PRODUCTO')
            ->get();




        foreach($productos as $p){
            if(is_null($p->stock)) {
                $p->stock = 0;
            }


            if(is_null($p->exento)) {
                $p->exento = 0;
            }
            if(is_null($p->precio)) {
                $p->precio = 0;
            }
            if(is_null($p->fecha_oferta)) {
                $p->fecha_oferta = "";
            }
            if(is_null($p->precio_oferta)) {
                $p->precio_oferta = "0";
            }

            //SELECT * FROM pack_producto WHERE RUT_EMPRESA='22222222-2' AND NOMBRE_PACK='PPACK'
            if(!empty($p->codigo)) {
                //dd($p);
                $p->productos_pack = DB::table('pack_producto')
                ->select('PROD_ADIC as codigo', 'CANTIDAD as cantidad')
                ->whereRaw('RUT_EMPRESA = \''.$usuario->rut_empresa.'\'')
                ->whereRaw('NOMBRE_PACK = \''.$p->codigo.'\'')
                ->get();
            }



        }

        Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            '',
            json_encode($productos),
            ENV('AMBIENTE_SII'),
            $request->ip()
        );

        return response()->json($productos);

    }

    public function productos_no_pack(Request $request)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $productos = DB::table('productos')
            ->select(
                'productos.CODIGO_PRODUCTO as codigo',
                'productos.CODIGOP_PRODUCTO as codigo_proveedor',
                'productos.DESCRIPCION_PRODUCTO as nombre',
                'productos.VALOR_PRODUCTO as precio',
                'productos.EXENTO_PRODUCTO as exento',
                'productos.PRECIO_OFERTA as precio_oferta',
                'productos.FECHA_OFERTA as fecha_oferta',
                'productos.ESTADO_PRODUCTO as estado',
                'productos.INV_PRODUCTO as tipo_producto_id',
                'productos.ID_UMEDIDA as unidad_medida_id',
                'productos.PESO_PRODUCTO as peso',
                'productos.altura as altura',
                'productos.ancho as ancho',
                'productos.longitud as longitud',
                'productos.ID_LINEAPRODUCTO as linea_id',
                'productos.ID_FAMILIAFAMILIA as familia_id',
                'productos.ID_FAMILIAPRODUCTO as sub_familia_id',
                'productos.id_marca as marca_id',
                DB::raw('(COALESCE((SELECT SUM(CANTIDAD_DOC)
                    FROM detalle_inv_productos
                    WHERE
                        detalle_inv_productos.TIPO_MOV = 1
                        AND `detalle_inv_productos`.`CODIGO_PRODUCTO` = `productos`.`CODIGO_PRODUCTO`
                        AND `detalle_inv_productos`.`RUT_EMPRESA` = `productos`.`ID_EMPRESA`
                    GROUP BY `detalle_inv_productos`.`CODIGO_PRODUCTO`), 0))
                    -
                    (COALESCE((SELECT SUM(CANTIDAD_DOC)
                        FROM detalle_inv_productos
                        WHERE
                            detalle_inv_productos.TIPO_MOV = 2
                            AND `detalle_inv_productos`.`CODIGO_PRODUCTO` = `productos`.`CODIGO_PRODUCTO`
                            AND `detalle_inv_productos`.`RUT_EMPRESA` = `productos`.`ID_EMPRESA`
                        GROUP BY `detalle_inv_productos`.`CODIGO_PRODUCTO`), 0)) as stock')
            )
            ->whereRaw('productos.ID_EMPRESA = \''.$usuario->rut_empresa.'\'')
            ->whereRaw('productos.INV_PRODUCTO != 14')
            ->leftJoin('detalle_inv_productos AS entrada', function ($join) {
                $join->on('entrada.CODIGO_PRODUCTO', '=', 'productos.CODIGO_PRODUCTO');
                $join->on('entrada.RUT_EMPRESA', '=', 'productos.ID_EMPRESA');
                $join->where('entrada.TIPO_MOV', '=', '1');
            })
            ->leftJoin('detalle_inv_productos AS salida', function ($join) {
                $join->on('salida.CODIGO_PRODUCTO', '=', 'productos.CODIGO_PRODUCTO');
                $join->on('salida.RUT_EMPRESA', '=', 'productos.ID_EMPRESA');
                $join->where('salida.TIPO_MOV', '=', '2');
            })
            ->groupBy('productos.CODIGO_PRODUCTO')
            ->get();

        foreach($productos as $p){
            if(is_null($p->stock)) {
                $p->stock = 0;
            }

            if(is_null($p->exento)) {
                $p->exento = 0;
            }
            if(is_null($p->precio)) {
                $p->precio = 0;
            }
            if(is_null($p->fecha_oferta)) {
                $p->fecha_oferta = "";
            }
            if(is_null($p->precio_oferta)) {
                $p->precio_oferta = "0";
            }
        }

        Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            '',
            json_encode($productos),
            ENV('AMBIENTE_SII'),
            $request->ip()
        );

        return response()->json($productos);

    }
    public function productos_no_pack_costo(Request $request, $codigo)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $conf_productos = DB::table('producto_conf')
        ->select('N_MESES_COSTO','ULTIMA_GUIA_AJUSTE')
        ->whereRaw('RUT_EMPRESA = \''.strtoupper($usuario->rut_empresa).'\'')
        ->get();
        $nuemro_meses = $costo_segun_ultima_guia_ajuste = 0;
        if(!empty($conf_productos)){
            $nuemro_meses = (int)$conf_productos[0]->N_MESES_COSTO;
            $costo_segun_ultima_guia_ajuste = $conf_productos[0]->ULTIMA_GUIA_AJUSTE;
        }
        
        
        

        $productos = DB::table('productos')
            ->select(
                'productos.CODIGO_PRODUCTO as codigo',
                'productos.CODIGOP_PRODUCTO as codigo_proveedor',
                'productos.DESCRIPCION_PRODUCTO as nombre',
                'productos.COSTO_REPOSICION as costo_maestro',
                'productos.VALOR_PRODUCTO as precio',
                'productos.EXENTO_PRODUCTO as exento',
                'productos.PRECIO_OFERTA as precio_oferta',
                'productos.FECHA_OFERTA as fecha_oferta',
                'productos.ESTADO_PRODUCTO as estado',
                'productos.INV_PRODUCTO as tipo_producto_id',
                'productos.ID_UMEDIDA as unidad_medida_id',
                'productos.PESO_PRODUCTO as peso',
                'productos.altura as altura',
                'productos.ancho as ancho',
                'productos.longitud as longitud',
                'productos.ID_LINEAPRODUCTO as linea_id',
                'productos.ID_FAMILIAFAMILIA as familia_id',
                'productos.ID_FAMILIAPRODUCTO as sub_familia_id',
                'productos.id_marca as marca_id',
                DB::raw('(COALESCE((SELECT SUM(CANTIDAD_DOC)
                    FROM detalle_inv_productos
                    WHERE
                        detalle_inv_productos.TIPO_MOV = 1
                        AND `detalle_inv_productos`.`CODIGO_PRODUCTO` = `productos`.`CODIGO_PRODUCTO`
                        AND `detalle_inv_productos`.`RUT_EMPRESA` = `productos`.`ID_EMPRESA`
                    GROUP BY `detalle_inv_productos`.`CODIGO_PRODUCTO`), 0))
                    -
                    (COALESCE((SELECT SUM(CANTIDAD_DOC)
                        FROM detalle_inv_productos
                        WHERE
                            detalle_inv_productos.TIPO_MOV = 2
                            AND `detalle_inv_productos`.`CODIGO_PRODUCTO` = `productos`.`CODIGO_PRODUCTO`
                            AND `detalle_inv_productos`.`RUT_EMPRESA` = `productos`.`ID_EMPRESA`
                        GROUP BY `detalle_inv_productos`.`CODIGO_PRODUCTO`), 0)) as stock')
            )
            ->whereRaw('productos.ID_EMPRESA = \''.$usuario->rut_empresa.'\'')
            ->whereRaw('productos.INV_PRODUCTO != 14')
            ->where('productos.CODIGO_PRODUCTO', '=', $codigo)
            ->leftJoin('detalle_inv_productos AS entrada', function ($join) {
                $join->on('entrada.CODIGO_PRODUCTO', '=', 'productos.CODIGO_PRODUCTO');
                $join->on('entrada.RUT_EMPRESA', '=', 'productos.ID_EMPRESA');
                $join->where('entrada.TIPO_MOV', '=', '1');
            })
            ->leftJoin('detalle_inv_productos AS salida', function ($join) {
                $join->on('salida.CODIGO_PRODUCTO', '=', 'productos.CODIGO_PRODUCTO');
                $join->on('salida.RUT_EMPRESA', '=', 'productos.ID_EMPRESA');
                $join->where('salida.TIPO_MOV', '=', '2');
            })
            ->groupBy('productos.CODIGO_PRODUCTO')
            ->get();

        foreach($productos as $p){
            if(is_null($p->stock)) {
                $p->stock = 0;
            }


            $p->costo = Producto::costo_prod($codigo, $usuario->rut_empresa,$nuemro_meses, $costo_segun_ultima_guia_ajuste);

            if(is_null($p->exento)) {
                $p->exento = 0;
            }
            if(is_null($p->precio)) {
                $p->precio = 0;
            }
            if(is_null($p->fecha_oferta)) {
                $p->fecha_oferta = "";
            }
            if(is_null($p->precio_oferta)) {
                $p->precio_oferta = "0";
            }
        }

        Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            '',
            json_encode($productos),
            ENV('AMBIENTE_SII'),
            $request->ip()
        );

        return response()->json($productos);

    }

    public function productosPaginaWeb(Request $request)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        //tipo producto
        $tipo_producto = DB::table('tipo_producto')
            ->select('ID_TIPOPRO','NOMBRE_TIPOPRO')
            ->get();
        $listadoTipoProducto = array();
        foreach ($tipo_producto as $key => $value) {
            $listadoTipoProducto[$value->ID_TIPOPRO] = $value->NOMBRE_TIPOPRO;
        }


        //unidad de medida
        $unidad_medida = DB::table('umedida')
            ->select('ID_UMEDIDA','NOMBRE_UMEDIDA')
            ->get();
        $listadoUnidadMedida = array();
        foreach ($unidad_medida as $key => $value) {
            $listadoUnidadMedida[$value->ID_UMEDIDA] = $value->NOMBRE_UMEDIDA;
        }

        //familia
        $familia = DB::table('producto_linea')
            ->select('idlinea','nombre_linea')
            ->whereRaw('rut_empresa = \''.$usuario->rut_empresa.'\'')
            ->get();
        $listadoFamilia = array();
        foreach ($familia as $key => $value) {
            $listadoFamilia[$value->idlinea] = $value->nombre_linea;
        }

        //Sub-familia
        $Subfamilia = DB::table('familiaproductos')
            ->select('ID_FAMILIAPRODUCTOS','NOMBRE_FAMILIAPRODUCTOS')
            ->whereRaw('ID_EMPRESA = \''.$usuario->rut_empresa.'\'')
            ->get();
        $listadoSubFamilia = array();
        foreach ($Subfamilia as $key => $value) {
            $listadoSubFamilia[$value->ID_FAMILIAPRODUCTOS] = $value->NOMBRE_FAMILIAPRODUCTOS;
        }

        //Linea
        $linea = DB::table('producto_subfamilia')
            ->select('idsubfamilia','nombre_subfamilia')
            ->whereRaw('rut_empresa = \''.$usuario->rut_empresa.'\'')
            ->get();
        $listadoLinea = array();
        foreach ($linea as $key => $value) {
            $listadoLinea[$value->idsubfamilia] = $value->nombre_subfamilia;
        }

        //marcas
        //$sql_marca = "SELECT id_marca_producto,descripcion FROM marca_producto WHERE id_empresa = '$datos_empresa_id' AND estado = '1'";

        $marcas = DB::table('marca_producto')
            ->select('id_marca_producto as id','descripcion as nombre')
            ->whereRaw('id_empresa = \''.$usuario->id_empresa.'\'')
            ->get();
        $listadoMarca = array();
        foreach ($marcas as $key => $value) {
            $listadoMarca[$value->id] = $value->nombre;
        }


        $productos = DB::table('productos')
            ->select(
                'productos.CODIGO_PRODUCTO as codigo',
                'productos.CODIGOP_PRODUCTO as codigo_proveedor',
                'productos.DESCRIPCION_PRODUCTO as nombre',
                'productos.DETALLE_LARGO as descripcion',
                'productos.VALOR_PRODUCTO as precio',
                'productos.EXENTO_PRODUCTO as exento',
                'productos.DESTACADO as destacado',
                'productos.NUEVO as nuevo',
                'productos.FNUEVO as fecha_limite_nuevo',
                'productos.PRECIO_OFERTA as precio_oferta',
                'productos.FECHA_OFERTA as fecha_oferta',
                'productos.id_marca as marca',
                'productos.PRODUCTO_IMAGEN as imagen',
                'productos.ESTADO_PRODUCTO as estado',
                'productos.PESO_PRODUCTO as peso',
                'productos.INV_PRODUCTO as tipo_producto_id',
                'productos.ID_UMEDIDA as unidad_medida_id',
                'productos.PESO_PRODUCTO as peso',
                'productos.altura as altura',
                'productos.ancho as ancho',
                'productos.longitud as longitud',
                'productos.ID_FAMILIAPRODUCTO as sub_familia',
                'productos.ID_FAMILIAFAMILIA as familia',
                'productos.ID_LINEAPRODUCTO as linea',
                'productos.id_marca as marca_id',
                DB::raw('(COALESCE((SELECT SUM(CANTIDAD_DOC)
                    FROM detalle_inv_productos
                    WHERE
                        detalle_inv_productos.TIPO_MOV = 1
                        AND `detalle_inv_productos`.`CODIGO_PRODUCTO` = `productos`.`CODIGO_PRODUCTO`
                        AND `detalle_inv_productos`.`RUT_EMPRESA` = `productos`.`ID_EMPRESA`
                    GROUP BY `detalle_inv_productos`.`CODIGO_PRODUCTO`), 0))
                    -
                    (COALESCE((SELECT SUM(CANTIDAD_DOC)
                        FROM detalle_inv_productos
                        WHERE
                            detalle_inv_productos.TIPO_MOV = 2
                            AND `detalle_inv_productos`.`CODIGO_PRODUCTO` = `productos`.`CODIGO_PRODUCTO`
                            AND `detalle_inv_productos`.`RUT_EMPRESA` = `productos`.`ID_EMPRESA`
                        GROUP BY `detalle_inv_productos`.`CODIGO_PRODUCTO`), 0)) as stock')
            )
            ->whereRaw('productos.ID_EMPRESA = \''.$usuario->rut_empresa.'\'')
            ->leftJoin('detalle_inv_productos AS entrada', function ($join) {
                $join->on('entrada.CODIGO_PRODUCTO', '=', 'productos.CODIGO_PRODUCTO');
                $join->on('entrada.RUT_EMPRESA', '=', 'productos.ID_EMPRESA');
                $join->where('entrada.TIPO_MOV', '=', '1');
            })
            ->leftJoin('detalle_inv_productos AS salida', function ($join) {
                $join->on('salida.CODIGO_PRODUCTO', '=', 'productos.CODIGO_PRODUCTO');
                $join->on('salida.RUT_EMPRESA', '=', 'productos.ID_EMPRESA');
                $join->where('salida.TIPO_MOV', '=', '2');
            })
            //->where('productos.CODIGO_PRODUCTO', '=', '00025')
            ->groupBy('productos.CODIGO_PRODUCTO')
            //->take(25)
            ->get();

        foreach($productos as $p){
            if(is_null($p->stock)) {
                $p->stock = 0;
            }
            if (!empty($p->marca)) {
                if (array_key_exists($p->marca, $listadoMarca)) {
                    $p->marca = $listadoMarca[$p->marca];
                }else{
                    $p->marca = 0;
                }

            }

            if (!empty($p->unidad_medida)) {
                $p->nombre_unidad_medida = $listadoUnidadMedida[$p->unidad_medida_id];
            }else{
                $p->nombre_unidad_medida = '';
            }

            if (!empty($p->familia)) {
                if (array_key_exists($p->familia, $listadoFamilia)) {
                    $p->familia = $listadoFamilia[$p->familia];
                }else{
                    $p->familia = 0;
                }
            }

            if (!empty($p->sub_familia)) {
                if (array_key_exists($p->sub_familia, $listadoSubFamilia)) {
                    $p->sub_familia = $listadoSubFamilia[$p->sub_familia];
                }else{
                    $p->sub_familia = 0;
                }
            }

            if (!empty($p->linea)) {
                if (array_key_exists($p->linea, $listadoSubFamilia)) {
                    $p->linea = $listadoLinea[$p->linea];
                }else{
                    $p->linea = 0;
                }
            }else{
                $p->linea = 0;
            }


            $productos_imagen = DB::table('productos')
                ->select(
                    'producto_imagen.IMAGEN2 as imagen1',
                    'producto_imagen.IMAGEN3 as imagen2',
                    'producto_imagen.IMAGEN4 as imagen3',
                    'producto_imagen.IMAGEN5 as imagen4',
                    'producto_imagen.IMAGEN_MINIMIZADA as minimizada'
                    )
                ->join('producto_imagen', 'producto_imagen.ID_PRODUCTO', '=', 'productos.ID_PRODUCTO')

                ->whereRaw('productos.ID_EMPRESA = \''.$usuario->rut_empresa.'\'')
                ->whereRaw('productos.CODIGO_PRODUCTO = \''.$p->codigo.'\'')
                ->get();
                //    http://www.softnet.cl/sistems/contabilidad/catalogo/producto/22222222-2/00025_2_logo-softnet.png

            $imagenes = array();
            foreach($productos_imagen as $imagen){
                //dd($imagen->imagen1);

                if(!empty($p->imagen)) {
                    //$imagen->imagen1 = $imagen->codigo.'_1_'.$imagen->imagen1;
                    $imagenes['imagen1'] = $p->imagen;
                }

                if(!empty($imagen->imagen1)) {
                    //$imagen->imagen1 = $imagen->codigo.'_1_'.$imagen->imagen1;
                    $imagenes['imagen2'] = $imagen->imagen1;
                }
                if(!empty($imagen->imagen2)) {
                    //$imagen->imagen2 = $imagen->codigo.'_2_'.$imagen->imagen2;
                    $imagenes['imagen3'] = $imagen->imagen2;
                }
                if(!empty($imagen->imagen3)) {
                    //$imagen->imagen3 = $imagen->codigo.'_3_'.$imagen->imagen3;
                    $imagenes['imagen4'] = $imagen->imagen3;
                }
                if(!empty($imagen->imagen4)) {
                    //$imagen->imagen4 = $imagen->codigo.'_4_'.$imagen->imagen4;
                    $imagenes['imagen5'] = $imagen->imagen4;
                }
                if(!empty($imagen->minimizada)) {
                    //$imagen->minimizada = $imagen->codigo.'_min_'.$imagen->minimizada;
                    $imagenes['imagen6'] = $imagen->minimizada;
                }
            }
            $imagenes = (object)$imagenes;
            $p->imagen = $imagenes;

        }

        Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            '',
            json_encode($productos),
            ENV('AMBIENTE_SII'),
            $request->ip()
        );

        return response()->json($productos);


    }

    public function productosPaginaWebBodega(Request $request, $id_bodega)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        //tipo producto
        $tipo_producto = DB::table('tipo_producto')
            ->select('ID_TIPOPRO','NOMBRE_TIPOPRO')
            ->get();
        $listadoTipoProducto = array();
        foreach ($tipo_producto as $key => $value) {
            $listadoTipoProducto[$value->ID_TIPOPRO] = $value->NOMBRE_TIPOPRO;
        }


        //unidad de medida
        $unidad_medida = DB::table('umedida')
            ->select('ID_UMEDIDA','NOMBRE_UMEDIDA')
            ->get();
        $listadoUnidadMedida = array();
        foreach ($unidad_medida as $key => $value) {
            $listadoUnidadMedida[$value->ID_UMEDIDA] = $value->NOMBRE_UMEDIDA;
        }

        //familia
        $familia = DB::table('producto_linea')
            ->select('idlinea','nombre_linea')
            ->whereRaw('rut_empresa = \''.$usuario->rut_empresa.'\'')
            ->get();
        $listadoFamilia = array();
        foreach ($familia as $key => $value) {
            $listadoFamilia[$value->idlinea] = $value->nombre_linea;
        }

        //Sub-familia
        $Subfamilia = DB::table('familiaproductos')
            ->select('ID_FAMILIAPRODUCTOS','NOMBRE_FAMILIAPRODUCTOS')
            ->whereRaw('ID_EMPRESA = \''.$usuario->rut_empresa.'\'')
            ->get();
        $listadoSubFamilia = array();
        foreach ($Subfamilia as $key => $value) {
            $listadoSubFamilia[$value->ID_FAMILIAPRODUCTOS] = $value->NOMBRE_FAMILIAPRODUCTOS;
        }

        //Linea
        $linea = DB::table('producto_subfamilia')
            ->select('idsubfamilia','nombre_subfamilia')
            ->whereRaw('rut_empresa = \''.$usuario->rut_empresa.'\'')
            ->get();
        $listadoLinea = array();
        foreach ($linea as $key => $value) {
            $listadoLinea[$value->idsubfamilia] = $value->nombre_subfamilia;
        }


        $productos = DB::table('productos')
            ->select(
                'productos.CODIGO_PRODUCTO as codigo',
                'productos.DESCRIPCION_PRODUCTO as nombre',
                'productos.DETALLE_LARGO as descripcion',
                'productos.VALOR_PRODUCTO as precio',
                'productos.EXENTO_PRODUCTO as exento',
                'productos.DESTACADO as destacado',
                'productos.PRECIO_OFERTA as precio_oferta',
                'productos.FECHA_OFERTA as fecha_oferta',
                'productos.PRODUCTO_IMAGEN as imagen',
                'productos.ESTADO_PRODUCTO as estado',
                'productos.PESO_PRODUCTO as peso',
                'productos.INV_PRODUCTO as tipo_producto_id',
                'productos.ID_UMEDIDA as unidad_medida_id',
                'productos.PESO_PRODUCTO as peso',
                'productos.altura as altura',
                'productos.ancho as ancho',
                'productos.longitud as longitud',
                'productos.ID_FAMILIAPRODUCTO as sub_familia_id',
                'productos.ID_FAMILIAFAMILIA as familia_id',
                'productos.ID_LINEAPRODUCTO as linea_id',
                'productos.id_marca as marca_id',
                DB::raw('(COALESCE((SELECT SUM(CANTIDAD_DOC)
                    FROM detalle_inv_productos
                    WHERE
                        detalle_inv_productos.TIPO_MOV = 1
                        AND `detalle_inv_productos`.`CODIGO_PRODUCTO` = `productos`.`CODIGO_PRODUCTO`
                        AND `detalle_inv_productos`.`RUT_EMPRESA` = `productos`.`ID_EMPRESA`
                    GROUP BY `detalle_inv_productos`.`CODIGO_PRODUCTO`), 0))
                    -
                    (COALESCE((SELECT SUM(CANTIDAD_DOC)
                        FROM detalle_inv_productos
                        WHERE
                            detalle_inv_productos.TIPO_MOV = 2
                            AND `detalle_inv_productos`.`CODIGO_PRODUCTO` = `productos`.`CODIGO_PRODUCTO`
                            AND `detalle_inv_productos`.`RUT_EMPRESA` = `productos`.`ID_EMPRESA`
                        GROUP BY `detalle_inv_productos`.`CODIGO_PRODUCTO`), 0)) as stock')
            )
            ->whereRaw('productos.ID_EMPRESA = \''.$usuario->rut_empresa.'\'')
            ->leftJoin('detalle_inv_productos AS entrada', function ($join) use ($id_bodega) {
                $join->on('entrada.CODIGO_PRODUCTO', '=', 'productos.CODIGO_PRODUCTO');
                $join->on('entrada.RUT_EMPRESA', '=', 'productos.ID_EMPRESA');
                $join->where('entrada.ID_BODEGA', '=', ''.$id_bodega.'');
                $join->where('entrada.TIPO_MOV', '=', '1');
            })
            ->leftJoin('detalle_inv_productos AS salida', function ($join) use ($id_bodega) {
                $join->on('salida.CODIGO_PRODUCTO', '=', 'productos.CODIGO_PRODUCTO');
                $join->on('salida.RUT_EMPRESA', '=', 'productos.ID_EMPRESA');
                $join->where('salida.ID_BODEGA', '=', ''.$id_bodega.'');
                $join->where('salida.TIPO_MOV', '=', '2');
            })
            ->groupBy('productos.CODIGO_PRODUCTO')
            //->take(25)
            ->get();

            foreach($productos as $p){
                if(is_null($p->stock)) {
                    $p->stock = 0;
                }
                //dd($listadoTipoProducto);

                //$p->nombre_tipoProducto = $listadoTipoProducto[$p->tipo_producto_id];

                if (!empty($p->unidad_medida)) {
                    $p->nombre_unidad_medida = $listadoUnidadMedida[$p->unidad_medida_id];
                }else{
                    $p->nombre_unidad_medida = '';
                }

                /*if (!empty($p->familia_id)) {
                    $p->familia = $listadoFamilia[$p->familia_id];
                }else{
                    $p->familia = "";
                }

                if (!empty($p->sub_familia_id)) {
                    $p->nombre_SubFamilia = $listadoSubFamilia[$p->sub_familia_id];
                }else{
                    $p->nombre_SubFamilia = "";
                }

                if (!empty($p->linea_id)) {
                    $p->nombre_linea = $listadoLinea[$p->linea_id];
                    //$p->nombre_linea = "algo";
                }else{
                    $p->nombre_linea = "";
                }*/

            }

        Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            '',
            json_encode($productos),
            ENV('AMBIENTE_SII'),
            $request->ip()
        );

        return response()->json($productos);

    }

    public function productosPaginaWebStockPositivo(Request $request)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        //tipo producto
        $tipo_producto = DB::table('tipo_producto')
            ->select('ID_TIPOPRO','NOMBRE_TIPOPRO')
            ->get();
        $listadoTipoProducto = array();
        foreach ($tipo_producto as $key => $value) {
            $listadoTipoProducto[$value->ID_TIPOPRO] = $value->NOMBRE_TIPOPRO;
        }


        //unidad de medida
        $unidad_medida = DB::table('umedida')
            ->select('ID_UMEDIDA','NOMBRE_UMEDIDA')
            ->get();
        $listadoUnidadMedida = array();
        foreach ($unidad_medida as $key => $value) {
            $listadoUnidadMedida[$value->ID_UMEDIDA] = $value->NOMBRE_UMEDIDA;
        }

        //familia
        $familia = DB::table('producto_linea')
            ->select('idlinea','nombre_linea')
            ->whereRaw('rut_empresa = \''.$usuario->rut_empresa.'\'')
            ->get();
        $listadoFamilia = array();
        foreach ($familia as $key => $value) {
            $listadoFamilia[$value->idlinea] = $value->nombre_linea;
        }

        //Sub-familia
        $Subfamilia = DB::table('familiaproductos')
            ->select('ID_FAMILIAPRODUCTOS','NOMBRE_FAMILIAPRODUCTOS')
            ->whereRaw('ID_EMPRESA = \''.$usuario->rut_empresa.'\'')
            ->get();
        $listadoSubFamilia = array();
        foreach ($Subfamilia as $key => $value) {
            $listadoSubFamilia[$value->ID_FAMILIAPRODUCTOS] = $value->NOMBRE_FAMILIAPRODUCTOS;
        }

        //Linea
        $linea = DB::table('producto_subfamilia')
            ->select('idsubfamilia','nombre_subfamilia')
            ->whereRaw('rut_empresa = \''.$usuario->rut_empresa.'\'')
            ->get();
        $listadoLinea = array();
        foreach ($linea as $key => $value) {
            $listadoLinea[$value->idsubfamilia] = $value->nombre_subfamilia;
        }


        $productos = DB::table('productos')
            ->select(
                'productos.CODIGO_PRODUCTO as codigo',
                'productos.DESCRIPCION_PRODUCTO as nombre',
                'productos.DETALLE_LARGO as descripcion',
                'productos.VALOR_PRODUCTO as precio',
                'productos.EXENTO_PRODUCTO as exento',
                'productos.DESTACADO as destacado',
                'productos.PRECIO_OFERTA as precio_oferta',
                'productos.FECHA_OFERTA as fecha_oferta',
                'productos.PRODUCTO_IMAGEN as imagen',
                'productos.ESTADO_PRODUCTO as estado',
                'productos.PESO_PRODUCTO as peso',
                'productos.INV_PRODUCTO as tipo_producto_id',
                'productos.ID_UMEDIDA as unidad_medida_id',
                'productos.PESO_PRODUCTO as peso',
                'productos.altura as altura',
                'productos.ancho as ancho',
                'productos.longitud as longitud',
                'productos.ID_FAMILIAPRODUCTO as sub_familia_id',
                'productos.ID_FAMILIAFAMILIA as familia_id',
                'productos.ID_LINEAPRODUCTO as linea_id',
                'productos.id_marca as marca_id',
                DB::raw('(COALESCE((SELECT SUM(CANTIDAD_DOC)
                    FROM detalle_inv_productos
                    WHERE
                        detalle_inv_productos.TIPO_MOV = 1
                        AND `detalle_inv_productos`.`CODIGO_PRODUCTO` = `productos`.`CODIGO_PRODUCTO`
                        AND `detalle_inv_productos`.`RUT_EMPRESA` = `productos`.`ID_EMPRESA`
                    GROUP BY `detalle_inv_productos`.`CODIGO_PRODUCTO`), 0))
                    -
                    (COALESCE((SELECT SUM(CANTIDAD_DOC)
                        FROM detalle_inv_productos
                        WHERE
                            detalle_inv_productos.TIPO_MOV = 2
                            AND `detalle_inv_productos`.`CODIGO_PRODUCTO` = `productos`.`CODIGO_PRODUCTO`
                            AND `detalle_inv_productos`.`RUT_EMPRESA` = `productos`.`ID_EMPRESA`
                        GROUP BY `detalle_inv_productos`.`CODIGO_PRODUCTO`), 0)) as stock')
            )
            ->whereRaw('productos.ID_EMPRESA = \''.$usuario->rut_empresa.'\'')
            ->leftJoin('detalle_inv_productos AS entrada', function ($join) {
                $join->on('entrada.CODIGO_PRODUCTO', '=', 'productos.CODIGO_PRODUCTO');
                $join->on('entrada.RUT_EMPRESA', '=', 'productos.ID_EMPRESA');
                $join->where('entrada.TIPO_MOV', '=', '1');
            })
            ->leftJoin('detalle_inv_productos AS salida', function ($join) {
                $join->on('salida.CODIGO_PRODUCTO', '=', 'productos.CODIGO_PRODUCTO');
                $join->on('salida.RUT_EMPRESA', '=', 'productos.ID_EMPRESA');
                $join->where('salida.TIPO_MOV', '=', '2');
            })
            ->groupBy('productos.CODIGO_PRODUCTO')
            //->take(25)
            ->get();

        $listado_productos = array();

        foreach($productos as $p){
            if(is_null($p->stock)) {
                $p->stock = 0;
            }

            //$p->nombre_tipoProducto = $listadoTipoProducto[$p->tipo_producto_id];

            if (!empty($p->unidad_medida)) {
                $p->nombre_unidad_medida = $listadoUnidadMedida[$p->unidad_medida_id];
            }else{
                $p->nombre_unidad_medida = '';
            }

            if (!empty($p->familia_id) AND !empty($listadoFamilia[$p->familia_id]) ) {
                $p->familia = $listadoFamilia[$p->familia_id];
            }else{
                $p->familia = "";
            }

            if (!empty($p->sub_familia_id) AND !empty($listadoSubFamilia[$p->sub_familia_id]) ) {
                $p->nombre_SubFamilia = $listadoSubFamilia[$p->sub_familia_id];
            }else{
                $p->nombre_SubFamilia = "";
            }

            /*if (!empty($p->linea_id)) {
                $p->nombre_linea = $listadoLinea[$p->linea_id];
                //$p->nombre_linea = "algo";
            }else{
                $p->nombre_linea = "";
            }*/

            if ($p->stock > 0 ) {
                $listado_productos['codigo'] = $p->codigo;
                $listado_productos['nombre'] = $p->nombre;
                $listado_productos['descripcion'] = $p->descripcion;
                $listado_productos['precio'] = $p->precio;
                $listado_productos['precio_oferta'] = $p->precio_oferta;
                $listado_productos['fecha_oferta'] = $p->fecha_oferta;
                $listado_productos['exento'] = $p->exento;
                $listado_productos['destacado'] = $p->destacado;
                $listado_productos['imagen'] = $p->imagen;
                $listado_productos['estado'] = $p->estado;
                $listado_productos['peso'] = $p->peso;
                /*$listado_productos['nombre_unidad_medida'] = $p->nombre_unidad_medida;
                $listado_productos['nombre_SubFamilia'] = $p->nombre_SubFamilia;
                $listado_productos['nombre_tipoProducto'] = $p->nombre_tipoProducto;
                $listado_productos['nombre_linea'] = $p->nombre_linea;*/
                $listado_productos['stock'] = $p->stock;
                $datos[] = $listado_productos;
            }

        }

        Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            '',
            json_encode($datos),
            ENV('AMBIENTE_SII'),
            $request->ip()
        );

        return response()->json($datos);
    }




    public function productoBodega(Request $request, $id_bodega)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }



        $productos = DB::table('productos')
            ->select(
                'productos.CODIGO_PRODUCTO as codigo',
                'productos.DESCRIPCION_PRODUCTO as nombre',
                'productos.VALOR_PRODUCTO as precio',
                'productos.EXENTO_PRODUCTO as exento',
                DB::raw('(COALESCE((SELECT SUM(CANTIDAD_DOC)
                    FROM detalle_inv_productos
                    WHERE
                        detalle_inv_productos.TIPO_MOV = 1
                        AND `detalle_inv_productos`.`CODIGO_PRODUCTO` = `productos`.`CODIGO_PRODUCTO`
                        AND `detalle_inv_productos`.`RUT_EMPRESA` = `productos`.`ID_EMPRESA`
                    GROUP BY `detalle_inv_productos`.`CODIGO_PRODUCTO`), 0))
                    -
                    (COALESCE((SELECT SUM(CANTIDAD_DOC)
                        FROM detalle_inv_productos
                        WHERE
                            detalle_inv_productos.TIPO_MOV = 2
                            AND `detalle_inv_productos`.`CODIGO_PRODUCTO` = `productos`.`CODIGO_PRODUCTO`
                            AND `detalle_inv_productos`.`RUT_EMPRESA` = `productos`.`ID_EMPRESA`
                        GROUP BY `detalle_inv_productos`.`CODIGO_PRODUCTO`), 0)) as stock')
            )

            /*->leftJoin('detalle_inv_productos AS entrada', function ($join) {
                $join->on('entrada.CODIGO_PRODUCTO', '=', 'productos.CODIGO_PRODUCTO');
                $join->on('entrada.RUT_EMPRESA', '=', 'productos.ID_EMPRESA');
                $join->where('entrada.TIPO_MOV', '=', '1');
            })
            ->leftJoin('detalle_inv_productos AS salida', function ($join) {
                $join->on('salida.CODIGO_PRODUCTO', '=', 'productos.CODIGO_PRODUCTO');
                $join->on('salida.RUT_EMPRESA', '=', 'productos.ID_EMPRESA');
                $join->where('salida.TIPO_MOV', '=', '2');
            })*/
            ->leftJoin('detalle_inv_productos AS inventario', function ($join) use ($id_bodega){
                $join->on('inventario.CODIGO_PRODUCTO', '=', 'productos.CODIGO_PRODUCTO');
                $join->on('inventario.RUT_EMPRESA', '=', 'productos.ID_EMPRESA');
                $join->where('inventario.ID_BODEGA', '=', ''.$id_bodega.'');
                //$join->where('salida.TIPO_MOV', '=', '2');
            })

            ->whereRaw('productos.ID_EMPRESA = \''.$usuario->rut_empresa.'\'')
            ->whereRaw('inventario.ID_BODEGA = \''.$id_bodega.'\'')

            ->groupBy('productos.CODIGO_PRODUCTO')
            ->get();

        foreach($productos as $p){
            if(is_null($p->stock)) {
                $p->stock = 0;
            }
        }

        Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            '',
            json_encode($productos),
            ENV('AMBIENTE_SII'),
            $request->ip()
        );

        return response()->json($productos);

    }

    public function preciowoopy(Request $request)
    {


        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        /*SELECT * FROM `lista_precio`
        INNER JOIN lista_precio_producto ON lista_precio.id=lista_precio_producto.id_lista_precio
        INNER JOIN productos ON productos.ID_EMPRESA=lista_precio.rut_empresa AND lista_precio_producto.id_producto=productos.ID_PRODUCTO WHERE rut_empresa='22222222-2' AND woopy='1' AND estado='1'
*/

        $listaPrecio = DB::table('lista_precio')
            ->select('CODIGO_PRODUCTO','precio')

            ->Join('lista_precio_producto', function ($join) {
                $join->on('lista_precio.id', '=', 'lista_precio_producto.id_lista_precio');
            })
            ->Join('productos', function ($join) {
                $join->on('productos.ID_EMPRESA', '=', 'lista_precio.rut_empresa');
                $join->on('productos.ID_PRODUCTO', '=', 'lista_precio_producto.id_producto');
            })

            ->whereRaw('rut_empresa = \''.$usuario->rut_empresa.'\'')
            ->whereRaw('woopy = 1')
            ->whereRaw('estado = 1')
            ->get();

        Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            '',
            json_encode($listaPrecio),
            ENV('AMBIENTE_SII'),
            $request->ip()
        );

        return response()->json($listaPrecio);

    }

    public function stockwoopy(Request $request)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }
        //SELECT * FROM `datos_empresa` WHERE rut='22222222-2'
        $datos_empresa = DB::table('datos_empresa')
            ->select('ID')
            ->whereRaw('rut = \''.$usuario->rut_empresa.'\'')
            ->get();

        //SELECT * FROM `bodegas` WHERE ID_EMPRESA='' AND woopy=''
        $bodegas = DB::table('bodegas')
            ->select('ID_BODEGAS','NOMBRE_BODEGAS')
            ->whereRaw('ID_EMPRESA = \''.$usuario->rut_empresa.'\'')
            ->whereRaw('woopy = 1')
            ->whereRaw('ESTADO_BODEGAS = 1')
            ->get();

        $datos = array();
        foreach ($bodegas as $key => $bodega) {
            // code...
            //SELECT * FROM `inventario_saldos` WHERE empresa_id='53' AND bodega_id='144' GROUP BY codigo_producto
            $codigos = DB::table('inventario_saldos')
            ->select('codigo_producto')
            ->whereRaw('empresa_id = \''.$datos_empresa[0]->ID.'\'')
            ->whereRaw('bodega_id = \''.$bodega->ID_BODEGAS.'\'')
            ->groupBy('codigo_producto')
            ->get();

            $listadoCodigos = array();
            foreach ($codigos as $key => $codigo) {
                // SELECT * FROM `inventario_saldos` WHERE empresa_id='53' AND bodega_id='144' AND codigo_producto='00025' ORDER BY `inventario_saldos`.`id` DESC LIMIT 5

                $stock = DB::table('inventario_saldos')
                ->select('saldo_unidades')
                ->whereRaw('empresa_id = 53')
                ->whereRaw('bodega_id = \''.$bodega->ID_BODEGAS.'\'')
                ->whereRaw('codigo_producto = \''.$codigo->codigo_producto.'\'')
                ->groupBy('id')
                ->orderBy('id', 'desc')
                ->get();

                //$arrayName = array($codigo->codigo_producto => $stock[0]->saldo_unidades);
                $arrayName[$codigo->codigo_producto] = $stock[0]->saldo_unidades;
            }
            array_push($listadoCodigos,$arrayName);
            $datos[$bodega->ID_BODEGAS] = $listadoCodigos;



        }

        Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            '',
            json_encode($datos),
            ENV('AMBIENTE_SII'),
            $request->ip()
        );

        return response()->json($datos);

    }

    public function imagenProductos(Request $request)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $productos = DB::table('productos')
            ->select(
                'productos.CODIGO_PRODUCTO as codigo',
                'producto_imagen.IMAGEN2 as imagen1',
                'producto_imagen.IMAGEN3 as imagen2',
                'producto_imagen.IMAGEN4 as imagen3',
                'producto_imagen.IMAGEN5 as imagen4',
                'producto_imagen.IMAGEN_MINIMIZADA as minimizada'
                )
            ->join('producto_imagen', 'producto_imagen.ID_PRODUCTO', '=', 'productos.ID_PRODUCTO')

            ->whereRaw('productos.ID_EMPRESA = \''.$usuario->rut_empresa.'\'')
            //->whereRaw('productos.CODIGO_PRODUCTO', '=', 'KSNUT001')
            ->get();
    //    http://www.softnet.cl/sistems/contabilidad/catalogo/producto/22222222-2/00025_2_logo-softnet.png

        foreach($productos as $p){
            if(!empty($p->imagen1)) {
                //$p->imagen1 = $p->codigo.'_1_'.$p->imagen1;
                $p->imagen1 = $p->imagen1;
            }
            if(!empty($p->imagen2)) {
                //$p->imagen2 = $p->codigo.'_2_'.$p->imagen2;
                $p->imagen2 = $p->imagen2;
            }
            if(!empty($p->imagen3)) {
                //$p->imagen3 = $p->codigo.'_3_'.$p->imagen3;
                $p->imagen3 = $p->imagen3;
            }
            if(!empty($p->imagen4)) {
                //$p->imagen4 = $p->codigo.'_4_'.$p->imagen4;
                $p->imagen4 = $p->imagen4;
            }
            if(!empty($p->minimizada)) {
                //$p->minimizada = $p->codigo.'_min_'.$p->minimizada;
                $p->minimizada = $p->minimizada;
            }
        }
        Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            '',
            json_encode($productos),
            ENV('AMBIENTE_SII'),
            $request->ip()
        );

        return response()->json($productos);

    }


    public function costo_por_producto(Request $request)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $conf_productos = DB::table('producto_conf')
        ->select('N_MESES_COSTO','ULTIMA_GUIA_AJUSTE')
        ->whereRaw('RUT_EMPRESA = \''.strtoupper($usuario->rut_empresa).'\'')
        ->get();

        $nuemro_meses = $conf_productos[0]->N_MESES_COSTO;
        $costo_segun_ultima_guia_ajuste = $conf_productos[0]->ULTIMA_GUIA_AJUSTE;

        $productos = DB::table('productos')
            ->select(
                'productos.CODIGO_PRODUCTO as codigo',
                'productos.DESCRIPCION_PRODUCTO as nombre',
                'productos.VALOR_PRODUCTO as precio',
                'productos.EXENTO_PRODUCTO as exento',
                'productos.INV_PRODUCTO as pack'
            )
            ->whereRaw('productos.ID_EMPRESA = \''.$usuario->rut_empresa.'\'')
            ->groupBy('productos.CODIGO_PRODUCTO')
            ->get();

        foreach($productos as $p){
            //costo por producto
            $costo = Producto::costo_prod($p->codigo, $usuario->rut_empresa,$nuemro_meses, $costo_segun_ultima_guia_ajuste);
            $p->costo = $costo;

            if ($p->pack == 14) {
                $p->pack = 'true';
            }else{
                $p->pack = 'false';
            }

        }

        Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            '',
            json_encode($productos),
            ENV('AMBIENTE_SII'),
            $request->ip()
        );

        return response()->json($productos);

    }


    public function listaPrecios(Request $request)
    {
        
        $datos = $request->json()->all();
        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $item = 0;
        $respuestas = [];
    
        $listas = DB::table('lista_precio')
            ->select(
                'id as id',
                'nombre_lista as nombre',
                'estado as estado'                    
                )
        ->whereRaw('rut_empresa = \''.$usuario->rut_empresa.'\'')
        ->get();
    
        $doc_temp = array();
        $documento = array();
        foreach ($listas as $key => $lista) {
            // code...
            $doc_temp['id'] = $lista->id;
            $doc_temp['nombre'] = $lista->nombre;
            $doc_temp['estado'] = $lista->estado;
            
            $detalles = DB::table('lista_precio_producto')
                ->select(
                    'CODIGO_PRODUCTO as codigo',
                    'precio as precio'
                )
                ->join('productos', 'lista_precio_producto.id_producto', '=', 'productos.ID_PRODUCTO')
                ->whereRaw('id_lista_precio = \''.$lista->id.'\'')

                ->get();
            $doc_temp['detalles'] = $detalles;


            unset($detalle_temp_final);

            $documento[$lista->nombre] = $doc_temp;

        }


        return response()->json($documento);
    }


    public function productos_b_Bodega(Request $request,$producto)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }
        //dd($producto);
        $listado = [];
        /*
        $productos = DB::table('productos_b')
            ->select(
                'CODIGO_PRODUCTO as codigo',
                'DESCRIPCION_PRODUCTO as nombre'
            )
            ->whereRaw('productos_b.ID_EMPRESA = \''.$usuario->rut_empresa.'\'')
            ->get();

        foreach($productos as $p){*/
            $bodegas = DB::table('bodegas')
                ->select( 'ID_BODEGAS as id','NOMBRE_BODEGAS as nombre' )
                ->whereRaw('bodegas.ID_EMPRESA = \''.$usuario->rut_empresa.'\'')
                ->get();
            foreach($bodegas as $b){
                //calcular stock por bodega
                /*$stock = DB::table('inventario')
                ->select( 'stock' )
                ->whereRaw('empresa_id = \''.$usuario->id_empresa.'\'')
                ->where('bodega_id', '=', $b->id)
                ->where('codigo', '=', $producto)
                ->get();*/
                //SELECT SUM(CANTIDAD_DOC) as cant FROM `detalle_inv_productos` WHERE RUT_EMPRESA='77554630-1' AND CODIGO_PRODUCTO='54303-F4200-3' AND TIPO_MOV=1 AND ID_BODEGA='385' 

                //consultar ingresos
                $ingreso = DB::table('detalle_inv_productos')
                ->whereRaw('RUT_EMPRESA = \''.$usuario->rut_empresa.'\'')
                ->where('ID_BODEGA', '=', $b->id)
                ->where('TIPO_MOV', '=', '1')
                ->where('CODIGO_PRODUCTO', '=', $producto)
                ->sum('CANTIDAD_DOC');
                
                
                //consultar egresos
                $egreso = DB::table('detalle_inv_productos')
                ->select( 'SUM(CANTIDAD_DOC) as cant' )
                ->whereRaw('RUT_EMPRESA = \''.$usuario->rut_empresa.'\'')
                ->where('ID_BODEGA', '=', $b->id)
                ->where('TIPO_MOV', '=', '2')
                ->where('CODIGO_PRODUCTO', '=', $producto)
                ->sum('CANTIDAD_DOC');

                $saldo = $ingreso - $egreso;
                
                
                //$stock = Producto::stock_por_producto($usuario->rut_empresa, $p->codigo, $b->id);
                if (!empty($saldo)) {
                    // code...
                    $listado[$b->id][$b->nombre] = $saldo;
                    //$p->id_bodega[$b->id] = (int)$stock[0]->stock;
                }else{
                    $listado[$b->id] = 0;
                    //$p->id_bodega[$b->id] = 0;
                }


            }

        //}

        Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            '',
            json_encode($listado),
            ENV('AMBIENTE_SII'),
            $request->ip()
        );
        return response()->json($listado);

    }

    public function stockInventario($rut_empresa, $codigo){
        //consultar ingresos
        
        $ingreso = DB::table('detalle_inv_productos')
        ->whereRaw('RUT_EMPRESA = \''.$rut_empresa.'\'')
        //->where('ID_BODEGA', '=', $b->id)
        ->where('TIPO_MOV', '=', '1')
        ->where('CODIGO_PRODUCTO', '=', $codigo)
        ->sum('CANTIDAD_DOC');
        
        
        //consultar egresos
        $egreso = DB::table('detalle_inv_productos')
        ->select( 'SUM(CANTIDAD_DOC) as cant' )
        ->whereRaw('RUT_EMPRESA = \''.$rut_empresa.'\'')
        //->where('ID_BODEGA', '=', $b->id)
        ->where('TIPO_MOV', '=', '2')
        ->where('CODIGO_PRODUCTO', '=', $codigo)
        ->sum('CANTIDAD_DOC');

        $saldo = $ingreso - $egreso;

        return $saldo;
    }

}
