<?php

namespace App\Models;

use App\Models\AreaNegocio;
use App\Models\Cliente;
use App\Models\FormaPago;
use App\Traits\Foliable;
//use App\Traits\Abstrahere;
use App\Api\AbstrahereApi;

use DB;

class NotaCredito
{
    use Foliable;
    //use Abstrahere;

    const NOTACREDITO = 61;

    public function __construct(
        $id_empresa,
        $rut_empresa,
        $rut_usuario,
        $rut_receptor,
        $fecha,
        $folio = 0,
        $montoNeto = 0,
        $montoExento = 0,
        $descuento = 0,
        $area_negocio,
        $condicion_pago,
        $vendedor,
        $observacion,
        array $detalles,
        array $referencia,
        array $adicionales

    ) {
        $this->id_empresa    = $id_empresa;
        $this->rut_empresa    = $rut_empresa;
        $this->rut_usuario    = $rut_usuario;
        $this->emisor         = $this->obtenDatosEmisor($rut_empresa);
        $this->receptor       = Cliente::obtenCliente(trim(strtoupper($rut_receptor)), $rut_empresa);
        $this->fecha           = $fecha;
        $this->tipo_documento = self::NOTACREDITO;
        $this->folio           = $folio;
        $this->monto_neto      = $montoNeto;
        $this->monto_exento      = $montoExento;
        $this->descuento      = $descuento;
        $this->area_negocio   = $area_negocio;
        $this->condicion_pago   = $condicion_pago;
        $this->vendedor   = $vendedor;
        $this->observacion    = $observacion;

        $this->detalles       = $detalles;
        $this->referencia    = $referencia;
        $this->adicionales    = $adicionales;

        $this->montos_totales = $this->calculaTotalesBoleta(
            $this->tipo_documento,
            $this->monto_neto,
            $this->monto_exento,
            $this->descuento
        );
    }

    protected function fallo($mensaje, $rollback = true, $registra_folio = true)
    {
        if ($registra_folio) {
            $this->registraFolioSinOcupar($this->rut_empresa, $this->tipo_documento, $this->folio);
        }
        if ($rollback) {
            $this->rollback();
        }
        return ['mensaje' => $mensaje];
    }

    public function ingresarNotaCredito()
    {
        if (is_null($this->receptor)) {
            return $this->fallo('Receptor invalido.', false, false);
        }

        if (!empty($this->monto_exento)) {
            return $this->fallo('Por el momento solo documentos afectos.', false, false);
        }


        $areaNegocio = AreaNegocio::obtenAreaNegocio($this->area_negocio, $this->rut_empresa);
        if (is_null($areaNegocio)) {
            return $this->fallo('# ' . $this->area_negocio . ' Area de Negocio invalida.', false, false);
        }

        $this->folio = $this->obtenFolio(
            $this->rut_empresa,
            self::NOTACREDITO
        );

        if (is_null($this->folio)) {
            return $this->fallo('No se pudo obtener folio.', false, true);
        }

        $formaPago = FormaPago::obtenFormaPago($this->condicion_pago, $this->rut_empresa);
        if (is_null($formaPago)) {
            return $this->fallo('# '.$this->condicion_pago.' - Forma de pago invalida.', false, false);
        }

        //validar que documento NO este anulado
        if($this->anuladoDocumentoReferencia()){
            return $this->fallo('Documento '.$this->referencia['Tipo'].' folio '.$this->referencia['Folio'].' Ya esta anulado.');
        }

        $this->adicionales['Uno']         = $formaPago->NOMBRE_CPAGO;
        $this->adicionales['Siete']       = isset($this->observacion) ? $this->observacion : '';


        //$this->adicionales['Treintayuno'] = $this->receptor->TELEFONO_CLIENTEPROVEEDOR;
        //$this->adicionales['Treintaydos'] = $this->receptor->FAX_CLIENTEPROVEEDOR;

        /*Datos del XML*/
        //dd( round(($this->montos_totales['neto']), 0, PHP_ROUND_HALF_UP) );
        $datos_xml = [
            'TipoDTE'      => self::NOTACREDITO,
            'Folio'        => $this->folio,
            'RUTEmisor'    => trim(strtoupper($this->rut_empresa)),
            'RznSoc'       => $this->emisor->razon,
            'GiroEmis'     => $this->emisor->giro1,
            'Telefono'     => $this->emisor->telefono,
            'Acteco'       => $this->emisor->codigo1,
            'DirOrigen'    => $this->emisor->direccion,
            'CmnaOrigen'   => $this->emisor->comuna,
            'CiudadOrigen' => $this->emisor->ciudad,

            'RUTRecep'     => trim(strtoupper($this->receptor->RUT_CLIENTEPROVEEDOR)),
            'RznSocRecep'  => $this->receptor->RZ_CLIENTEPROVEEDOR,
            'DirRecep'     => $this->receptor->DIRECCION_DIRECCION,
            'CmnaRecep'    => $this->receptor->ID_COMUNA,
            'CiudadRecep'  => $this->receptor->ID_CIUDAD,

            'neto'         => round(($this->montos_totales['neto']), 0, PHP_ROUND_HALF_UP),
            'tasaIVA'      => round((19), 0, PHP_ROUND_HALF_UP),
            'iva'          => round(($this->montos_totales['iva']), 0, PHP_ROUND_HALF_UP),
            'total'        => round(($this->montos_totales['total']), 0, PHP_ROUND_HALF_UP),
            'exento'       => round(($this->montos_totales['exento']), 0, PHP_ROUND_HALF_UP),
            'MntTotal'     => round(($this->montos_totales['total']), 0, PHP_ROUND_HALF_UP),
            'Detalles'     => [],
        ];

        //validar cantidad de lineas de detalle
        $cantidad_detalles = $this->cantidadLineasDetalle($this->referencia);
        if ($cantidad_detalles != count($this->detalles)) {
            return $this->fallo('Cantidad de lineas de detalle no coincide con el documento referenciado');
        }

        //se valida si existe el documento referenciado
        if(!$this->validaDocumentoReferencia($this->referencia)){
            return $this->fallo('Documento Tipo: ' . $this->referencia['Tipo'] . ' Folio: '.$this->referencia['Folio'].' No existe.');
        }

        if (!$this->ingresaReferencia($this->referencia, $this->tipoReferencia())) {
            return $this->fallo('No se pudo realizar el ingreso de las referencias.');
        }


        if ($this->referencia['Tipo'] == 46) {
            // ingreso a libro de compras
            return $this->fallo('Por el momento NO se puede Anular a un documento de compra');
        }else{

            $id_ingreso_lv = $this->ingresoLibroVentas($formaPago);
            if (!$id_ingreso_lv) {
                return $this->fallo('Excepción al ingresar datos libro ventas.');
            }

            if (!$this->ingresoCtaCte($id_ingreso_lv)) {
                return $this->fallo('No se pudo realizar ingreso en ctacte.');
            }

            if ($this->descuento > 0) {
                if (!$this->ingresoDescGlobal($id_ingreso_lv)) {
                    return $this->fallo('No se pudo realizar ingreso en descuento global.');
                }
            }

        }

        if (!$this->ingresoAdicionalLibroVentas()) {
            return $this->fallo('No se pudo realizar ingreso de los campos adicionales.');
        }

        if (!$this->ingresoDirLibroVenta()) {
            return $this->fallo('No se pudo realizar ingreso en direccion libro de ventas.');
        }



        $totalDetalle = $totalDetalleExento = 0;
        foreach ($this->detalles as $detalle) {

            $bodega = Bodega::obtenBodega($detalle['Bodega'], $this->rut_empresa);

            if (is_null($bodega)) {
                return $this->fallo('Bodega ' . $detalle['Bodega'] . ' invalida.');
            }

            $producto = Producto::obtenProducto($detalle['Codigo'], $this->rut_empresa);
            if (is_null($producto)) {
                return $this->fallo('Producto ' . $detalle['Codigo'] . ' invalido.');
            }


            $detalle['Precio'] = !isset($detalle['Precio']) ? $producto->VALOR_PRODUCTO : $detalle['Precio'];


            if ($detalle['Afecto']) {
                $exento     = 0;
                $neto       = round(($detalle['Precio'] * $detalle['Cantidad']), 0, PHP_ROUND_HALF_UP);
                $total      = round(($neto - $detalle['Descuento']), 0, PHP_ROUND_HALF_UP);
                $id_usuario = '';
                $totalDetalle += $total;
            } else {
                $exento     = round(($detalle['Precio'] * $detalle['Cantidad']), 0, PHP_ROUND_HALF_UP);
                $neto       = 0;
                $total      = round(($exento - $detalle['Descuento']), 0, PHP_ROUND_HALF_UP);
                $id_usuario = 'x';
                $totalDetalleExento += $total;
            }


            $datos_xml['Detalles'][] = [
                'VlrCodigo' => $producto->CODIGO_PRODUCTO,
                'NmbItem'   => $producto->DESCRIPCION_PRODUCTO,
                'QtyItem'   => $detalle['Cantidad'],
                'UnmdItem'  => $producto->NOMBRE,
                'PrcItem'   => $detalle['Precio'],
                'MontoItem' => $total,
            ];


            ;
            if (!$this->ingresaDetalleDoc2($detalle, $producto, $exento, $neto, $total, $id_usuario, $id_ingreso_lv)) {
                return $this->fallo('No se pudo realizar el ingreso de detalle.');
            }

            //devolver productos pack
            $detalle_inv = $this->ingresoDetalleInvProductos($producto, $detalle, $bodega);

            if ($detalle_inv != 'true') {
                return $this->fallo('No se pudo realizar el ingreso de detalle de inventario. ERROR: '.$detalle_inv);
            }

        }

        


        //si se anula documento completo los datos deben ser iguales al documento referenciado
        // si se corrige texto los totales deben estar en 0
        // si se corrige montos, debe haber valores menores o igual al documento referenciado

        //'1' => 'Anula Documento de Referencia.',
        //'2' => 'Corrige Texto Documento de Referencia.',
        //'3' => 'Corrige Montos.'

        //se valida si es por corrige monto o por anulacion, que los totales sean mayor a cero

        if ($this->referencia['CodigoNC'] == 1) {

            if (($this->montos_totales['neto'] + $this->montos_totales['exento']) == 0) {
                return $this->fallo('Nota de credito debe ser mayor a cero, por el tipo de referencia.');
            }
        }elseif ($this->referencia['CodigoNC'] == 2) {
            if (($this->montos_totales['neto'] + $this->montos_totales['exento'] + $this->montos_totales['iva']) > 0) {
                return $this->fallo('Nota de credito debe ser igual a cero, por el tipo de referencia.');
            }

        }

        


        //se valida si existe el xml en habstrahere
        /*if(!$this->validaXMLDocumentoReferencia($this->referencias)){
            return $this->fallo('Documento XML Tipo: ' . $this->referencias['TipoRef'] . ' Folio: '.$this->referencias['FolioRef'].' No existe.');
        }*/
        //array(5) { ["Tipo"]=> string(2) "33" ["Folio"]=> string(4) "4284" ["Fecha"]=> string(10) "2020-05-01" ["CodigoNC"]=> string(1) "1" ["Razon"]=> string(27) "Se anula documento completo" }
        //dd($this->referencia);
        $datos_xml['Referencias'][] = [
            'NroLinRef' => $this->referencia['Numero'],
            'TpoDocRef' => $this->referencia['Tipo'],
            'TipoDoc'  => $this->referencia['Tipo'],
            'FolioRef'  => $this->referencia['Folio'],
            'FchRef'    => $this->referencia['Fecha'],
            'CodRef'    => $this->referencia['CodigoNC'],
            'RazonRef'  => $this->referencia['Razon'],
        ];

        if ($detalle['Afecto']) {
            //$totalDetalleNeto
            if ($totalDetalle != $this->montos_totales['neto']) {
                return $this->fallo('MontoNeto no coincide con sumatoria de detalles, valor debería ser: ' . $totalDetalle . '.');
            }
        }else {
            //$total Detalle Exento
            if ($totalDetalleExento != $this->montos_totales['exento']) {
                return $this->fallo('Monto exento no coincide con sumatoria de detalles, valor debería ser: ' . $totalDetalleExento . '.');
            }
        }


        $suma_monto_total = $this->montos_totales['neto'] + $this->montos_totales['exento'] + $this->montos_totales['iva'];


        if ($suma_monto_total != $this->montos_totales['total']) {
            return $this->fallo('Monto total no coincide con sumatoria, Monto: ' . ($this->montos_totales['neto'] + $this->montos_totales['exento'] + $this->montos_totales['iva']) . '.');
        }

        //anular dcumento referenciado solo si es anulado completo
        if ($this->referencia['CodigoNC'] == 1) {
            if (!$this->pagarDocumentoReferenciado()) {
                return $this->fallo('No pudo dejar pagado documento referenciado.');
            }
        }
        

        

        $abstrahere = new AbstrahereApi($this->rut_empresa, $this->rut_usuario);
                
        $adicional_xml = $this->generaXmlAdicionalesApi($this->adicionales);
        $datapost = $this->generaXml($datos_xml,$adicional_xml);

        $xml = json_decode($abstrahere->POST("/xmls", $datapost));

        if(empty($xml->folio)){
            return $this->fallo('Error al generar documento, tipo:'.$this->tipo_documento.' folio: '.$this->folio.' '.json_encode($xml),false, false);
        }

        $urlPDF = '';
        $url = '/pdfs/'.$this->rut_empresa.'/'.$this->tipo_documento.'/'.$this->folio;
        $header_opcional = 'idImpreso: 1';

        $xml_pdf = $abstrahere->GET($url,$header_opcional);
        $xml_pdf = $abstrahere->JSON_TO_ARRAY($xml_pdf);
        if (!empty($xml_pdf['signedURL'])) {
            $urlPDF = $xml_pdf['signedURL'];
        }

        return [
            'mensaje' => 'Item guardado con exito.',
            'folio'   => $this->folio,
            'pdf'     => $urlPDF,
        ];
    }

    protected function obtenDatosEmisor($rut_emisor)
    {
        return DB::table('datos_empresa')
            ->whereRaw('rut = \'' . $rut_emisor . '\'')
            ->where('ESISTEMA', '=', 1)
            ->first();
    }

    protected function obtenDatosUsuario()
    {
        return DB::table('datos_usuarios')
            ->whereRaw('rut = \'' . $this->rut_empresa . '\'')
            ->whereRaw('rut_p = \'' . $this->rut_usuario . '\'')
            ->where('ACTIVO', '=', 1)
            ->first();
    }

    protected function ingresoLibroVentas($formaPago)
    {
        $datos_usuario = $this->obtenDatosUsuario();

        try {
            $id_ingreso_lv = DB::table('libro_ventas')
                ->insertGetId([
                    'rut'                => $this->rut_empresa,
                    'mes'                => date('m', time()),
                    'fecha'              => date('Y-m-d', time()),
                    'typo_doc'           => $this->tipo_documento,
                    'n_doc'              => $this->folio,
                    'rut_c'              => strtoupper($this->receptor->RUT_CLIENTEPROVEEDOR),
                    'nombre_c'           => $this->receptor->RZ_CLIENTEPROVEEDOR,
                    'EXENTO_LVENTA'      => $this->formateaNumero($this->montos_totales['exento']),
                    'DESCUENTO_LVENTA'   => $this->formateaNumero(0),
                    'ESPECIFICO_LVENTA'  => 0,
                    'valor_n'            => "-".$this->formateaNumero($this->montos_totales['neto']),
                    'valor_i'            => "-".$this->formateaNumero($this->montos_totales['iva']),
                    'IVARETENIDO_LVENTA' => 0,
                    'valor_t'            => "-".$this->formateaNumero($this->montos_totales['total']),
                    'ANO_LVENTA'         => date('Y', time()),
                    'CTACTE_LVENTA'      => 1,
                    'FPAGO_LVENTA'       => $formaPago->DIAS_CPAGO,
                    'ANEGOCIO_LVENTA'    => $this->area_negocio,
                    'SUCURSAL_LVENTA'    => $datos_usuario->BODEGA,
                    'OBS_LVENTA'         => $this->observacion,
                    'DISPONIBLE1_LVENTA' => $formaPago->NOMBRE_CPAGO,
                    'DISPONIBLE2_LVENTA' => $this->adicionales['Dos'],
                    'DISPONIBLE3_LVENTA' => '',
                    'DISPONIBLE4_LVENTA' => '',
                    'DISPONIBLE5_LVENTA' => '',
                    'DISPONIBLE6_LVENTA' => date('Y-m-d', strtotime('+' . $formaPago->DIAS_CPAGO . ' day', time())),
                    'FINGRESO_LVENTAS'   => date('Y-m-d'),
                    'UINGRESO_LVENTAS'   => $this->rut_usuario,
                    'ID_ENVIO'           => 1,
                    'datos_empresa_id'   => $this->id_empresa,
                ]);

        } catch (Exception $e) {
            return false;
        }

        return $id_ingreso_lv;
    }

    protected function ingresoCtaCte($id_ingreso_lv)
    {

        try {
            $ingreso = DB::table('ctacte')
                ->insert([
                    'rut_empresa'  => $this->rut_empresa,
                    'rut_c'        => $this->receptor->RUT_CLIENTEPROVEEDOR,
                    'n_doc_ctacte' => $this->folio,
                    'tipo_doc'     => $this->formateaNumero($this->tipo_documento),
                    'total_ctacte' => "-".$this->formateaNumero($this->montos_totales['total']),
                    'pagos_ctacte' => 0,
                    'saldo_ctacte' => "-".$this->formateaNumero($this->montos_totales['total']),
                    'datos_empresa_id' => $this->id_empresa,
                    'libro_ventas_id' => $id_ingreso_lv,
                ]);
        } catch (Exception $e) {
            return false;
        }
        return $ingreso;
    }

    protected function ingresoDescGlobal($id_lventa)
    {

        try {
            $ingreso = DB::table('desc_global')
                ->insert([
                    'ID_EMPRESA' => $this->rut_empresa,
                    'FOLIO_DOC'  => $this->folio,
                    'TIPO_DOC'   => $this->tipo_documento,
                    'TIPO_DESC'  => 2,
                    'VALOR_DESC' => $this->formateaNumero($this->descuento),
                    'ADICIONAL1' => '',
                    'ADICIONAL2' => '',
                    'ADICIONAL3' => '',
                    'datos_empresa_id' => $this->id_empresa,
                    'libro_ventas_id' => $id_lventa,
                ]);
        } catch (Exception $e) {
            return false;
        }

        return $ingreso;
    }

    protected function ingresoDirLibroVenta()
    {
        try {
            $ingreso = DB::table('dir_libro_venta')
                ->insert([
                    'ID_EMPRESA'           => $this->rut_empresa,
                    'FOLIO_DIR_LVENTA'     => $this->folio,
                    'TIPO_DIR_LVENTA'      => $this->tipo_documento,
                    'ID_DIRECCION'         => $this->receptor->ID_DIRECCION,
                    'ADICIONAL_DIR_LVENTA' => '',
                ]);
        } catch (Exception $e) {
            return false;
        }

        return $ingreso;
    }

    protected function ingresoAdicionalLibroVentas()
    {
        try {
            $ingreso = DB::table('adicional_libro_ventas')
                ->insert([
                    'RUT_EMPRESA' => $this->rut_empresa,
                    'RUT_CLIENTE' => $this->receptor->RUT_CLIENTEPROVEEDOR,
                    'typo_doc'    => $this->tipo_documento,
                    'n_doc'       => $this->folio,
                    'PORCENTAJE_CREDITO'    => 0,
                    'TOTAL_CREDITO'         => 0,
                    'NRECUPERABLE_LVENTAS'  => 0,
                    'BODEGA_DES'            => 0,
                    'RUT_EXTRANJERO'        => 0
                ]);
        } catch (Exception $e) {
            return false;
        }

        return $ingreso;
    }

    protected function ingresaDetalleDoc2($detalle, $producto, $exento, $neto, $total, $id_usuario, $id_ingreso_lv)
    {
        try {
            $ingreso = DB::table('detalle_doc2')
                ->insert([
                    'RUT_EMPRESA'           => $this->rut_empresa,
                    'RUT_CLIENTE'           => $this->receptor->RUT_CLIENTEPROVEEDOR,
                    'ID_CORRE_DETALLEDOC'   => $this->folio,
                    'ID_TIPODOC'            => $this->tipo_documento,
                    'CPROD_DETALLEDOC'      => $producto->CODIGO_PRODUCTO,
                    'DETALLE_DETALLEDOC'    => $producto->DESCRIPCION_PRODUCTO,
                    'ESPECIFICO_DETALLEDOC' => '',
                    'EXENTO_DETALLEDOC'     => $exento,
                    'NETO_DETALLEDOC'       => $neto,
                    'CANTIDAD_DETALLEDOC'   => $detalle['Cantidad'],
                    'TIPODESC__DETALLEDOC'  => 1,
                    'VADESC__DETALLEDOC'    => $detalle['Descuento'],
                    'DESC__DETALLEDOC'      => $detalle['Descuento'],
                    'TOTAL_DETALLEDOC'      => $total,
                    'ID_USUARIO'            => $id_usuario,
                    'FECHA_DETALLEDOC'      => date('Y-m-d', time()),
                    'ESTADO_DETALLEDOC'     => 2,
                    'datos_empresa_id'      => $this->id_empresa,
                    'libro_ventas_id'       => $id_ingreso_lv,
                ]);
        } catch (Exception $e) {
            return false;
        }

        return $ingreso;
    }

    protected function tipoReferencia(){

        $tipo_nc = array(
            '1' => 'Anula Documento de Referencia.',
            '2' => 'Corrige Texto Documento de Referencia.',
            '3' => 'Corrige Montos.'
        );

        return $tipo_nc;

    }

    protected function ingresaReferencia($referencia, $tipoReferencia)
    {

        $idTipoLibro = ($referencia['Tipo'] == '46') ? 2 : 1;

        try {
            $ingreso = DB::table('nc_sistema')
            ->insert([
                'RUT_EMPRESA' => $this->rut_empresa,
                'ID_TIPO'    => $referencia['Tipo'], //tipo doc que se referencia
                'NC_DOC'    => $this->folio,    // folio de nota de credito
                'NDOC'    => $referencia['Folio'],   //folio doc que se referencia
                'FECHA_DOC'    => $referencia['Fecha'],  //fecha del documento referenciado
                'TIPO_NC'    => $referencia['CodigoNC'],     //tipo de NC 1,2,3
                'RAZON_NC'    => $tipoReferencia[$referencia['CodigoNC']],   //razon segun tipo de nota de credito
                'DETALLE_NC'    => $referencia['Razon'],
                'ADICIONAL1'    => $this->tipo_documento,
                'ADICIONAL2'    => '',
                'ADICIONAL3'    => $idTipoLibro,
            ]);
        } catch (Exception $e) {
            return false;
        }


        return $ingreso;
    }

    protected function obtieneFolioTesoreria(){

        $corre = 0;
        $codigo = 5;
        $tabla = ($codigo == 5) ? "comp_cancela" : "comp_cancelap";

        $corre_folio = DB::table('corre_folios')
            ->select('FOLIO')
            ->whereRaw('RUT_EMPRESA = \'' . $this->rut_empresa . '\'')
            ->whereRaw('CODIGO = 5')
            ->first();
        
            
        if (empty($corre_folio)) {
            
            $correlativo = DB::table('comp_cancela')
            ->whereRaw('RUT_C = \'' . $this->rut_empresa . '\'')
            ->count();
            $corre	= 1 + $correlativo;
            $correa	= $corre;

            DB::table('corre_folios')
            ->insert([
                'RUT_EMPRESA' => $this->rut_empresa,
                'CODIGO' => '5',
                'FOLIO' => $corre,
            ]);
        }else{
            $corre = $corre_folio->FOLIO;
            $correa	= $corre+1;

            DB::table('corre_folios')
                ->whereRaw('RUT_EMPRESA = \'' . $this->rut_empresa . '\'')
                ->whereRaw('CODIGO = 5')
                ->update([
                    'FOLIO' => $correa,
                ]);
        }
        


        
        return $corre;
    }

    protected function pagarDocumentoReferenciado(){
        $date = date('Y-m-d');
        $estado =  true;

        $libro_venta = DB::table('libro_ventas')
            ->select('CTACTE_LVENTA')
            ->whereRaw('rut = \'' . $this->rut_empresa . '\'')
            ->whereRaw('typo_doc = \'' . $this->referencia['Tipo'] . '\'')
            ->whereRaw('n_doc = \'' . $this->referencia['Folio'] . '\'')
            ->first();
        
        //validar que si tiene un abono NO generar el pago automatico
        $ctacte = DB::table('ctacte')
            ->select('pagos_ctacte')
            ->whereRaw('rut_empresa = \'' . $this->rut_empresa . '\'')
            ->whereRaw('tipo_doc = \'' . $this->referencia['Tipo'] . '\'')
            ->whereRaw('n_doc_ctacte = \'' . $this->referencia['Folio'] . '\'')
            ->first();
        

        if($libro_venta->CTACTE_LVENTA == '1' AND $ctacte->pagos_ctacte==0){
            DB::table('libro_ventas')
                ->whereRaw('rut = \'' . $this->rut_empresa . '\'')
                ->whereRaw('typo_doc = \'' . $this->referencia['Tipo'] . '\'')
                ->whereRaw('n_doc = \'' .$this->referencia['Folio']. '\'')
                ->update([
                    'CTACTE_LVENTA' => '2',
                ]);
            
            //obtener numero de comprobante
            $numero_comprobante = $this->obtieneFolioTesoreria();
            
            $id_comp = DB::table('comp_cancela')
                ->insertGetId([
                    'N_COMP' => $numero_comprobante,
                    'FECHA_COMP' => $date,
                    'RUT_C' => $this->rut_empresa,
                    'RUT_E' => trim(strtoupper($this->receptor->RUT_CLIENTEPROVEEDOR)),
                    'TIPO_COMP' => 'notacredito',
                    'banco' => '',
                    'FECHA_ING' => $date,
                    'FECHA_DOC' => $date,
                    'serie' => '',
                    'adicional1' => '1',
                    'adicional2' => '',
                    'adicional3' => '',
                    'adicional4' => '',
                    'adicional5' => '',
                    'MONTO_COMP' => '',
                    'datos_empresa_id' => $this->id_empresa
                ]);
           
            DB::table('ctacte_notacredito')
                ->insert([
                    'id_ing' => $numero_comprobante,
                    'rut_empresa' => $this->rut_empresa,
                    'n_doc' => $this->referencia['Folio'],
                    'tipo_doc' => $this->referencia['Tipo'],
                    'monto' => $this->formateaNumero($this->montos_totales['total']),
                    'usuario' => $this->rut_usuario,
                    'ADICIONAL1' => $date,
                    'ADICIONAL2' => '1',
                    'ADICIONAL3' => '',
                    'ADICIONAL4' => '',
                ]);

            DB::table('ctacte_notacredito')
                ->insert([
                    'id_notacredito' => '',
                    'id_ing' => $numero_comprobante,
                    'rut_empresa' => $this->rut_empresa,
                    'n_doc' => $this->folio,
                    'tipo_doc' => $this->tipo_documento,
                    'monto' => '-'.$this->formateaNumero($this->montos_totales['total']),
                    'usuario' => $this->rut_usuario,
                    'ADICIONAL1' => $date,
                    'ADICIONAL2' => '1',
                    'ADICIONAL3' => '',
                    'ADICIONAL4' => '',
                ]);
            
            DB::table('tb_ctacte_general')
                ->insert([
                    'ID_CTACTE_GENERAL' => '',
                    'N_COMP_CANCELA' => $numero_comprobante,
                    'RUT_EMPRESA' => $this->rut_empresa,
                    'N_DOC' => $this->referencia['Folio'],
                    'TIPO_DOC' => $this->referencia['Tipo'],
                    'ABONO_ADOC' => $this->formateaNumero($this->montos_totales['total']),
                    'U_INGRESO' => $this->rut_usuario,
                    'ESTADO_COMP' => '1',
                    'SALDO_CTACTE' => '0',
                    'ID_COMP' => $id_comp,
                ]);

            DB::table('tb_ctacte_general')
                ->insert([
                    'ID_CTACTE_GENERAL' => '',
                    'N_COMP_CANCELA' => $numero_comprobante,
                    'RUT_EMPRESA' => $this->rut_empresa,
                    'N_DOC' => $this->folio,
                    'TIPO_DOC' => $this->tipo_documento,
                    'ABONO_ADOC' => '-'.$this->formateaNumero($this->montos_totales['total']),
                    'U_INGRESO' => $this->rut_usuario,
                    'ESTADO_COMP' => '1',
                    'SALDO_CTACTE' => '0',
                    'ID_COMP' => $id_comp,
                ]);

            DB::table('ctacte')
                ->whereRaw('rut_empresa = \'' . $this->rut_empresa . '\'')
                ->whereRaw('tipo_doc = \'' . $this->referencia['Tipo'] . '\'')
                ->whereRaw('n_doc_ctacte = \'' .$this->referencia['Folio']. '\'')
                ->update([
                    'pagos_ctacte' => $this->formateaNumero($this->montos_totales['total']),
                    'saldo_ctacte' => '0'
                ]);


            DB::table('ctacte')
                ->whereRaw('rut_empresa = \'' . $this->rut_empresa . '\'')
                ->whereRaw('tipo_doc = \'' . $this->tipo_documento . '\'')
                ->whereRaw('n_doc_ctacte = \'' .$this->folio. '\'')
                ->update([
                    'pagos_ctacte' => "-".$this->formateaNumero($this->montos_totales['total']),
                    'saldo_ctacte' => '0'
                ]);

            //actualizar a pagado nota de credito
            DB::table('libro_ventas')
                ->whereRaw('rut = \'' . $this->rut_empresa . '\'')
                ->whereRaw('typo_doc = \'' . $this->tipo_documento . '\'')
                ->whereRaw('n_doc = \'' .$this->folio. '\'')
                ->update([
                    'CTACTE_LVENTA' => 2,
                ]);
        }
        
        return $estado;

    }

    protected function anuladoDocumentoReferencia(){

        //SELECT * FROM `nc_sistema` 
        //WHERE RUT_EMPRESA='76017114-K' AND ADICIONAL1='61' AND ID_TIPO='33' AND NDOC='8169' ORDER BY `nc_sistema`.`NC_DOC` DESC; 
        
        //SELECT * FROM `nc_sistema` 
        //WHERE RUT_EMPRESA='76073217-6' AND ADICIONAL1='61' AND NDOC='345469' AND ID_TIPO='39'; 
        $doc = DB::table('nc_sistema')
            ->whereRaw('RUT_EMPRESA = \'' . $this->rut_empresa . '\'')
            ->whereRaw('ADICIONAL1 = \'' . $this->tipo_documento . '\'')
            ->whereRaw('ID_TIPO = \'' . $this->referencia['Tipo'] . '\'')
            ->whereRaw('NDOC = \'' . $this->referencia['Folio'] . '\'')
            ->count();
        //dd($doc);

        if($doc > 0){
            return true;
        }
        return false;
    }

    protected function validaDocumentoReferencia(){



        $libro_venta = DB::table('libro_ventas')
            ->whereRaw('rut = \'' . $this->rut_empresa . '\'')
            ->whereRaw('typo_doc = \'' . $this->referencia['Tipo'] . '\'')
            ->whereRaw('n_doc = \'' . $this->referencia['Folio'] . '\'')
            ->count();


        if(!empty($libro_venta)){
            return true;
        }
        return false;
    }

    protected function cantidadLineasDetalle($referencia){

        $detalles = DB::table('detalle_doc2')
            ->whereRaw('RUT_EMPRESA = \'' . $this->rut_empresa . '\'')
            ->whereRaw('ID_TIPODOC = \'' . $referencia['Tipo'] . '\'')
            ->whereRaw('ID_CORRE_DETALLEDOC = \'' . $referencia['Folio'] . '\'')
            ->count();

        return $detalles;

    }
    protected function validaXMLDocumentoReferencia($referencia){

        $datos['rut'] = $this->rut_empresa;
        $datos['tipo'] = $referencia['TipoRef'];
        $datos['folio'] = $referencia['FolioRef'];
        $datos['cedible'] = 1;

        $xml_consulta_pdf = $this->consultaPDF($datos);

        $respuesta = $this->integrar($xml_consulta_pdf);
        $respuesta = (array) simplexml_load_string($respuesta->IntegracionResult);

        if($respuesta['IdResultado'] != 115){
            return true;
        }
        return false;

    }


    protected function ingresoDetalleInvProductos($producto, $detalle, $bodega)
    {
        $ingreso = '';

        if ($producto->INV_PRODUCTO != 14) {
            try {

                $ingreso = DB::table('detalle_inv_productos')
                    ->insert([
                        'CODIGO_PRODUCTO'        => $producto->CODIGO_PRODUCTO,
                        'FECHA_INGRESO'          => date('Y-m-d', time()),
                        'FECHA_MOV'              => date('Y-m-d H:i:s', time()),
                        'TIPO_MOV'               => 1,
                        'FECHA_DOC'              => date('Y-m-d', time()),
                        'FOLIO_DOC'              => $this->tipo_documento,
                        'N_DOC'                  => $this->folio,
                        'RUT_EMPRESA'            => $this->rut_empresa,
                        'OBS'                    => isset($this->observacion) ? $this->observacion : '',
                        'CANTIDAD_DOC'           => $detalle['Cantidad'],
                        'VALOR_PRODUCTO'         => $detalle['Precio'],
                        'ID_BODEGA'              => $bodega->ID_BODEGAS,
                        'CANTIDAD_INV'           => $detalle['Cantidad'],
                        'CORRE_COMPRA'           => 0,
                        'ADICIONAL1_DETALLE_INV' => $this->rut_usuario,
                        'datos_empresa_id'     => $this->id_empresa,
                    ]);
            } catch (Exception $e) {
                return $e." NORMAL";
            }
        }else{
            try {

                $datos_pack = DB::table('pack_producto')
                    ->select('PROD_ADIC', 'CANTIDAD', 'VALOR_PRODUCTO')
                    ->join('productos', 'pack_producto.ID_PRODUCTO', '=', 'productos.ID_PRODUCTO')
                    ->whereRaw('RUT_EMPRESA = \''.$this->rut_empresa.'\'')
                    ->whereRaw('NOMBRE_PACK = \''.$producto->CODIGO_PRODUCTO.'\'')
                    ->get();

                foreach ($datos_pack as $key => $pack) {
                    $codigo_pack = $pack->PROD_ADIC;
                    $cantidad_pack = $pack->CANTIDAD * $detalle['Cantidad'];
                    $neto_pack = (int) $pack->VALOR_PRODUCTO;

                    $precio_pack = $neto_pack * $cantidad_pack;

                    $ingreso = DB::table('detalle_inv_productos')
                        ->insert([
                            'CODIGO_PRODUCTO' => $codigo_pack,
                            'FECHA_INGRESO' => date('Y-m-d', time()),
                            'FECHA_MOV' => date('Y-m-d H:i:s', time()),
                            'TIPO_MOV' => 1,
                            'FECHA_DOC' => date('Y-m-d', time()),
                            'FOLIO_DOC' => $this->tipo_documento,
                            'N_DOC' => $this->folio,
                            'RUT_EMPRESA' => $this->rut_empresa,
                            'OBS' => isset($this->observacion) ? $this->observacion : '',
                            'CANTIDAD_DOC' => $cantidad_pack,
                            'VALOR_PRODUCTO' => $precio_pack,
                            'ID_BODEGA' => $detalle['Bodega'],
                            'CANTIDAD_INV' => $detalle['Cantidad'],
                            'CORRE_COMPRA' => 0,
                            'ADICIONAL1_DETALLE_INV' => $this->rut_usuario,
                            'datos_empresa_id' => $this->id_empresa,
                        ]);
                }
            } catch (Exception $e) {
                return $e." PACK";
            }

        }

        return $ingreso;
    }

    protected function calculaTotalesBoleta($tipoDocumento, $montoNeto, $montoExento, $descuento)
    {
        $montosTotales = [];

        $montosTotales['neto'] = $montoNeto;
        $montosTotales['iva'] = ($montoNeto - $descuento) * env('IVA');
        $montosTotales['total'] = ($montoNeto - $descuento) + $montosTotales['iva'];
        $montosTotales['exento'] = $montoExento;

        return $montosTotales;
    }

    protected function rollback()
    {
        $ingreso = DB::table('libro_ventas')
            ->whereRaw('rut = \'' . $this->rut_empresa . '\'')
            ->where('typo_doc', '=', $this->tipo_documento)
            ->where('n_doc', '=', $this->folio)
            ->delete();

        $ingreso = DB::table('ctacte')
            ->whereRaw('rut_empresa = \'' . $this->rut_empresa . '\'')
            ->where('tipo_doc', '=', $this->tipo_documento)
            ->where('n_doc_ctacte', '=', $this->folio)
            ->delete();

        $ingreso = DB::table('desc_global')
            ->whereRaw('ID_EMPRESA = \'' . $this->rut_empresa . '\'')
            ->where('TIPO_DOC', '=', $this->tipo_documento)
            ->where('FOLIO_DOC', '=', $this->folio)
            ->delete();

        $ingreso = DB::table('dir_libro_venta')
            ->whereRaw('ID_EMPRESA = \'' . $this->rut_empresa . '\'')
            ->where('TIPO_DIR_LVENTA', '=', $this->tipo_documento)
            ->where('FOLIO_DIR_LVENTA', '=', $this->folio)
            ->delete();

        $ingreso = DB::table('adicional_libro_ventas')
            ->whereRaw('RUT_EMPRESA = \'' . $this->rut_empresa . '\'')
            ->where('typo_doc', '=', $this->tipo_documento)
            ->where('n_doc', '=', $this->folio)
            ->delete();

        $ingreso = DB::table('detalle_doc2')
            ->whereRaw('RUT_EMPRESA = \'' . $this->rut_empresa . '\'')
            ->where('ID_TIPODOC', '=', $this->tipo_documento)
            ->where('ID_CORRE_DETALLEDOC', '=', $this->folio)
            ->delete();

        $ingreso = DB::table('detalle_inv_productos')
            ->whereRaw('RUT_EMPRESA = \'' . $this->rut_empresa . '\'')
            ->where('FOLIO_DOC', '=', $this->tipo_documento)
            ->where('N_DOC', '=', $this->folio)
            ->delete();

        $ingreso = DB::table('ref_sistema_ge_especial')
            ->whereRaw('RUT_EMPRESA = \'' . $this->rut_empresa . '\'')
            ->where('ADICIONAL2', '=', $this->tipo_documento)
            ->where('ADICIONAL1', '=', $this->folio)
            ->delete();

        $ingreso = DB::table('nc_sistema')
            ->whereRaw('RUT_EMPRESA = \'' . $this->rut_empresa . '\'')
            ->where('ADICIONAL1', '=', $this->tipo_documento)
            ->where('NC_DOC', '=', $this->folio)
            ->delete();
    }

    protected function generaXmlNotaCredito($datos)
    {

        $xml_detalle = '';
        $item        = 1;

        foreach ($datos['Detalles'] as $detalle) {
            $xml_detalle .= '<Detalle>
               <NroLinDet>' . $item . '</NroLinDet>
               <CdgItem>
                  <TpoCodigo />
                  <VlrCodigo>' . $detalle['VlrCodigo'] . '</VlrCodigo>
               </CdgItem>
               <NmbItem>' . $detalle['NmbItem'] . '</NmbItem>
               <QtyItem>' . $detalle['QtyItem'] . '</QtyItem>
               <UnmdItem>' . $detalle['UnmdItem'] . '</UnmdItem>
               <PrcItem>' . $detalle['PrcItem'] . '</PrcItem>
               <MontoItem>' . $detalle['MontoItem'] . '</MontoItem>
            </Detalle>' . PHP_EOL;
            $item++;

        }

        $xml_referencia = '';
        $itemRef        = 1;
        foreach ($datos['Referencias'] as $referencia) {

            $xml_referencia .= '<Referencia>
                <NroLinRef>' . $itemRef . '</NroLinRef>
                <TpoDocRef>' . $referencia['TpoDocRef'] . '</TpoDocRef>
                <FolioRef>' . $referencia['FolioRef'] . '</FolioRef>
                <FchRef>' . $referencia['FchRef'] . '</FchRef>
                <CodRef>' . $referencia['CodRef'] . '</CodRef>
                <RazonRef>' . $referencia['RazonRef'] . '</RazonRef>
                </Referencia>' . PHP_EOL;
            $itemRef++;

        }

        $xml = '<DTE version="1.0">
            <Documento ID="F674T33">
               <Encabezado>
                  <IdDoc>
                     <TipoDTE>' . $datos['TipoDTE'] . '</TipoDTE>
                     <Folio>' . $datos['Folio'] . '</Folio>
                     <FchEmis>' . date('Y-m-d', time()) . '</FchEmis>
                  </IdDoc>
                  <Emisor>
                     <RUTEmisor>' . $datos['RUTEmisor'] . '</RUTEmisor>
                     <RznSoc>' . $datos['RznSoc'] . '</RznSoc>
                     <GiroEmis>' . $datos['GiroEmis'] . '</GiroEmis>
                     <Telefono>' . $datos['Telefono'] . '</Telefono>
                     <Acteco>' . $datos['Acteco'] . '</Acteco>
                     <DirOrigen>' . $datos['DirOrigen'] . '</DirOrigen>
                     <CmnaOrigen>' . $datos['CmnaOrigen'] . '</CmnaOrigen>
                     <CiudadOrigen>' . $datos['CiudadOrigen'] . '</CiudadOrigen>
                  </Emisor>
                  <Receptor>
                     <RUTRecep>' . $datos['RUTRecep'] . '</RUTRecep>
                     <RznSocRecep>' . $datos['RznSocRecep'] . '</RznSocRecep>
                     <DirRecep>' . $datos['DirRecep'] . '</DirRecep>
                     <CmnaRecep>' . $datos['CmnaRecep'] . '</CmnaRecep>
                     <CiudadRecep>' . $datos['CiudadRecep'] . '</CiudadRecep>
                  </Receptor>
                  <Totales>
                     <MntNeto>' . $datos['neto'] . '</MntNeto>
                     <MntExe>' . $datos['exento'] . '</MntExe>
                     <TasaIVA>' . $datos['tasaIVA'] . '</TasaIVA>
                     <IVA>' . $datos['iva'] . '</IVA>
                     <MntTotal>' . $datos['MntTotal'] . '</MntTotal>
                  </Totales>
               </Encabezado>
               ' . $xml_detalle . '
               ' . $xml_referencia . '
            </Documento>
         </DTE>';

        return $xml;
    }

    protected function generaXml($datos,$adicionales)
    {
        $xml_detalle = '';
        $item        = 1;

        foreach ($datos['Detalles'] as $detalle) {
            $xml_detalle .= '<Detalle>
               <NroLinDet>' . $item . '</NroLinDet>
               <CdgItem>
                  <TpoCodigo />
                  <VlrCodigo>' . $detalle['VlrCodigo'] . '</VlrCodigo>
               </CdgItem>
               <NmbItem>' . $detalle['NmbItem'] . '</NmbItem>
               <QtyItem>' . $detalle['QtyItem'] . '</QtyItem>
               <UnmdItem>' . $detalle['UnmdItem'] . '</UnmdItem>
               <PrcItem>' . $detalle['PrcItem'] . '</PrcItem>
               <MontoItem>' . $detalle['MontoItem'] . '</MontoItem>
            </Detalle>' . PHP_EOL;
            $item++;

        }

        $xml_referencia = '';
        $itemRef        = 1;
        foreach ($datos['Referencias'] as $referencia) {

            $xml_referencia .= '<Referencia>
                <NroLinRef>' . $itemRef . '</NroLinRef>
                <TpoDocRef>' . $referencia['TpoDocRef'] . '</TpoDocRef>
                <FolioRef>' . $referencia['FolioRef'] . '</FolioRef>
                <FchRef>' . $referencia['FchRef'] . '</FchRef>
                <CodRef>' . $referencia['CodRef'] . '</CodRef>
                <RazonRef>' . $referencia['RazonRef'] . '</RazonRef>
                </Referencia>' . PHP_EOL;
            $itemRef++;

        }

        $xml = '
            <Body>
                <DTE>
                    <Documento>
                    <Encabezado>
                        <IdDoc>
                            <TipoDTE>' . $datos['TipoDTE'] . '</TipoDTE>
                            <Folio>' . $datos['Folio'] . '</Folio>
                            <FchEmis>' . date('Y-m-d', time()) . '</FchEmis>
                        </IdDoc>
                        <Emisor>
                            <RUTEmisor>' . $datos['RUTEmisor'] . '</RUTEmisor>
                            <RznSoc>' . $datos['RznSoc'] . '</RznSoc>
                            <GiroEmis>' . $datos['GiroEmis'] . '</GiroEmis>
                            <Telefono>' . $datos['Telefono'] . '</Telefono>
                            <Acteco>' . $datos['Acteco'] . '</Acteco>
                            <DirOrigen>' . $datos['DirOrigen'] . '</DirOrigen>
                            <CmnaOrigen>' . $datos['CmnaOrigen'] . '</CmnaOrigen>
                            <CiudadOrigen>' . $datos['CiudadOrigen'] . '</CiudadOrigen>
                        </Emisor>
                        <Receptor>
                            <RUTRecep>' . $datos['RUTRecep'] . '</RUTRecep>
                            <RznSocRecep>' . $datos['RznSocRecep'] . '</RznSocRecep>
                            <DirRecep>' . $datos['DirRecep'] . '</DirRecep>
                            <CmnaRecep>' . $datos['CmnaRecep'] . '</CmnaRecep>
                            <CiudadRecep>' . $datos['CiudadRecep'] . '</CiudadRecep>
                        </Receptor>
                        <Totales>
                            <MntNeto>' . $datos['neto'] . '</MntNeto>
                            <MntExe>' . $datos['exento'] . '</MntExe>
                            <TasaIVA>' . $datos['tasaIVA'] . '</TasaIVA>
                            <IVA>' . $datos['iva'] . '</IVA>
                            <MntTotal>' . $datos['MntTotal'] . '</MntTotal>
                        </Totales>
                        
                    </Encabezado>
                    '.$xml_detalle.'
                    '.$xml_referencia.'
                    

                    </Documento>

                    <Adicionales>
                        '.$adicionales.'
                    </Adicionales>
                </DTE>
                <idImpreso></idImpreso>
            </Body>
            ';

            

         return $xml;


    }

    protected function generaXmlAdicionalesApi($datos)
    {
        $xml = '<Uno>'.(isset($datos['Uno']) ? $datos['Uno'] : '').'</Uno>
    	       <Dos>'.(isset($datos['Dos']) ? $datos['Dos'] : '').'</Dos>
               <Tres>'.(isset($datos['Tres']) ? $datos['Tres'] : '').'</Tres>
               <Cuatro>'.(isset($datos['Cuatro']) ? $datos['Cuatro'] : '').'</Cuatro>
               <Cinco>'.(isset($datos['Cinco']) ? $datos['Cinco'] : '').'</Cinco>
               <Seis>'.(isset($datos['Seis']) ? $datos['Seis'] : '').'</Seis>
               <Siete>'.(isset($datos['Siete']) ? $datos['Siete'] : '').'</Siete>
               <Ocho>'.(isset($datos['Ocho']) ? $datos['Ocho'] : '').'</Ocho>
               <Nueve>'.(isset($datos['Nueve']) ? $datos['Nueve'] : '').'</Nueve>
               <Diez>'.(isset($datos['Diez']) ? $datos['Diez'] : '').'</Diez>
               <Once>'.(isset($datos['Once']) ? $datos['Once'] : '').'</Once>
               <Doce>'.(isset($datos['Doce']) ? $datos['Doce'] : '').'</Doce>
               <Trece>'.(isset($datos['Trece']) ? $datos['Trece'] : '').'</Trece>
               <Catorce>'.(isset($datos['Catorce']) ? $datos['Catorce'] : '').'</Catorce>
               <Quince>'.(isset($datos['Quince']) ? $datos['Quince'] : '').'</Quince>
               <Dieciseis>'.(isset($datos['Dieciseis']) ? $datos['Dieciseis'] : '').'</Dieciseis>
               <Diecisiete>'.(isset($datos['Diecisiete']) ? $datos['Diecisiete'] : '').'</Diecisiete>
               <Dieciocho>'.(isset($datos['Dieciocho']) ? $datos['Dieciocho'] : '').'</Dieciocho>
               <Diecinueve>'.(isset($datos['Diecinueve']) ? $datos['Diecinueve'] : '').'</Diecinueve>
               <Veinte>'.(isset($datos['Veinte']) ? $datos['Veinte'] : '').'</Veinte>
               <Veintiuno>'.(isset($datos['Veintiuno']) ? $datos['Veintiuno'] : '').'</Veintiuno>
               <Veintidos>'.(isset($datos['Veintidos']) ? $datos['Veintidos'] : '').'</Veintidos>
               <Veintitres>'.(isset($datos['Veintitres']) ? $datos['Veintitres'] : '').'</Veintitres>
               <Veinticuatro>'.(isset($datos['Veinticuatro']) ? $datos['Veinticuatro'] : '').'</Veinticuatro>
               <Veinticinco>'.(isset($datos['Veinticinco']) ? $datos['Veinticinco'] : '').'</Veinticinco>
               <Veintiseis>'.(isset($datos['Veintiseis']) ? $datos['Veintiseis'] : '').'</Veintiseis>
               <Veintisiete>'.(isset($datos['Veintisiete']) ? $datos['Veintisiete'] : '').'</Veintisiete>
               <Veintiocho>'.(isset($datos['Veintiocho']) ? $datos['Veintiocho'] : '').'</Veintiocho>
               <Veintinueve>'.(isset($datos['Veintinueve']) ? $datos['Veintinueve'] : '').'</Veintinueve>
               <Treinta>'.(isset($datos['Treinta']) ? $datos['Treinta'] : '').'</Treinta>
               <Treintayuno>'.(isset($datos['Treintayuno']) ? $datos['Treintayuno'] : '').'</Treintayuno>
               <Treintaydos>'.(isset($datos['Treintaydos']) ? $datos['Treintaydos'] : '').'</Treintaydos>
               <Treintaytres>'.(isset($datos['Treintaytres']) ? $datos['Treintaytres'] : '').'</Treintaytres>
               <Treintaycuatro>'.(isset($datos['Treintaycuatro']) ? $datos['Treintaycuatro'] : '').'</Treintaycuatro>
               <Treintaycinco>'.(isset($datos['Treintaycinco']) ? $datos['Treintaycinco'] : '').'</Treintaycinco>
               <Treintayseis>'.(isset($datos['Treintayseis']) ? $datos['Treintayseis'] : '').'</Treintayseis>
               <Treintaysiete>'.(isset($datos['Treintaysiete']) ? $datos['Treintaysiete'] : '').'</Treintaysiete>
               <Treintayocho>'.(isset($datos['Treintayocho']) ? $datos['Treintayocho'] : '').'</Treintayocho>
               <Treintaynueve>'.(isset($datos['Treintaynueve']) ? $datos['Treintaynueve'] : '').'</Treintaynueve>
               <Cuarenta>'.(isset($datos['Cuarenta']) ? $datos['Cuarenta'] : '').'</Cuarenta>
               <Cuarentayuno>'.(isset($datos['Cuarentayuno']) ? $datos['Cuarentayuno'] : '').'</Cuarentayuno>
               <Cuarentaydos>'.(isset($datos['Cuarentaydos']) ? $datos['Cuarentaydos'] : '').'</Cuarentaydos>
               <Cuarentaytres>'.(isset($datos['Cuarentaytres']) ? $datos['Cuarentaytres'] : '').'</Cuarentaytres>
               <Cuarentaycuatro>'.(isset($datos['Cuarentaycuatro']) ? $datos['Cuarentaycuatro'] : '').'</Cuarentaycuatro>
               <Cuarentaycinco>'.(isset($datos['Cuarentaycinco']) ? $datos['Cuarentaycinco'] : '').'</Cuarentaycinco>
               <Cuarentayseis>'.(isset($datos['Cuarentayseis']) ? $datos['Cuarentayseis'] : '').'</Cuarentayseis>
               <Cuarentaysiete>'.(isset($datos['Cuarentaysiete']) ? $datos['Cuarentaysiete'] : '').'</Cuarentaysiete>
               <Cuarentayocho>'.(isset($datos['Cuarentayocho']) ? $datos['Cuarentayocho'] : '').'</Cuarentayocho>
               <Cuarentaynueve>'.(isset($datos['Cuarentaynueve']) ? $datos['Cuarentaynueve'] : '').'</Cuarentaynueve>
               <Cincuenta>'.(isset($datos['Cincuenta']) ? $datos['Cincuenta'] : '').'</Cincuenta>';

       return $xml;
    }

    protected function generaXmlAdicionales($datos)
    {
        $xml = '<Adicional>
               <Uno>' . (isset($datos['Uno']) ? $datos['Uno'] : '') . '</Uno>
               <Dos>' . (isset($datos['Dos']) ? $datos['Dos'] : '') . '</Dos>
               <Tres>' . (isset($datos['Tres']) ? $datos['Tres'] : '') . '</Tres>
               <Cuatro>' . (isset($datos['Cuatro']) ? $datos['Cuatro'] : '') . '</Cuatro>
               <Cinco>' . (isset($datos['Cinco']) ? $datos['Cinco'] : '') . '</Cinco>
               <Seis>' . (isset($datos['Seis']) ? $datos['Seis'] : '') . '</Seis>
               <Siete>' . (isset($datos['Siete']) ? $datos['Siete'] : '') . '</Siete>
               <Ocho>' . (isset($datos['Ocho']) ? $datos['Ocho'] : '') . '</Ocho>
               <Nueve>' . (isset($datos['Nueve']) ? $datos['Nueve'] : '') . '</Nueve>
               <Diez>' . (isset($datos['Diez']) ? $datos['Diez'] : '') . '</Diez>
               <Once>' . (isset($datos['Once']) ? $datos['Once'] : '') . '</Once>
               <Doce>' . (isset($datos['Doce']) ? $datos['Doce'] : '') . '</Doce>
               <Trece>' . (isset($datos['Trece']) ? $datos['Trece'] : '') . '</Trece>
               <Catorce>' . (isset($datos['Catorce']) ? $datos['Catorce'] : '') . '</Catorce>
               <Quince>' . (isset($datos['Quince']) ? $datos['Quince'] : '') . '</Quince>
               <Dieciseis>' . (isset($datos['Dieciseis']) ? $datos['Dieciseis'] : '') . '</Dieciseis>
               <Diecisiete>' . (isset($datos['Diecisiete']) ? $datos['Diecisiete'] : '') . '</Diecisiete>
               <Dieciocho>' . (isset($datos['Dieciocho']) ? $datos['Dieciocho'] : '') . '</Dieciocho>
               <Diecinueve>' . (isset($datos['Diecinueve']) ? $datos['Diecinueve'] : '') . '</Diecinueve>
               <Veinte>' . (isset($datos['Veinte']) ? $datos['Veinte'] : '') . '</Veinte>
               <Veintiuno>' . (isset($datos['Veintiuno']) ? $datos['Veintiuno'] : '') . '</Veintiuno>
               <Veintidos>' . (isset($datos['Veintidos']) ? $datos['Veintidos'] : '') . '</Veintidos>
               <Veintitres>' . (isset($datos['Veintitres']) ? $datos['Veintitres'] : '') . '</Veintitres>
               <Veinticuatro>' . (isset($datos['Veinticuatro']) ? $datos['Veinticuatro'] : '') . '</Veinticuatro>
               <Veinticinco>' . (isset($datos['Veinticinco']) ? $datos['Veinticinco'] : '') . '</Veinticinco>
               <Veintiseis>' . (isset($datos['Veintiseis']) ? $datos['Veintiseis'] : '') . '</Veintiseis>
               <Veintisiete>' . (isset($datos['Veintisiete']) ? $datos['Veintisiete'] : '') . '</Veintisiete>
               <Veintiocho>' . (isset($datos['Veintiocho']) ? $datos['Veintiocho'] : '') . '</Veintiocho>
               <Veintinueve>' . (isset($datos['Veintinueve']) ? $datos['Veintinueve'] : '') . '</Veintinueve>
               <Treinta>' . (isset($datos['Treinta']) ? $datos['Treinta'] : '') . '</Treinta>
               <Treintayuno>' . (isset($datos['Treintayuno']) ? $datos['Treintayuno'] : '') . '</Treintayuno>
               <Treintaydos>' . (isset($datos['Treintaydos']) ? $datos['Treintaydos'] : '') . '</Treintaydos>
               <Treintaytres>' . (isset($datos['Treintaytres']) ? $datos['Treintaytres'] : '') . '</Treintaytres>
               <Treintaycuatro>' . (isset($datos['Treintaycuatro']) ? $datos['Treintaycuatro'] : '') . '</Treintaycuatro>
               <Treintaycinco>' . (isset($datos['Treintaycinco']) ? $datos['Treintaycinco'] : '') . '</Treintaycinco>
               <Treintayseis>' . (isset($datos['Treintayseis']) ? $datos['Treintayseis'] : '') . '</Treintayseis>
               <Treintaysiete>' . (isset($datos['Treintaysiete']) ? $datos['Treintaysiete'] : '') . '</Treintaysiete>
               <Treintayocho>' . (isset($datos['Treintayocho']) ? $datos['Treintayocho'] : '') . '</Treintayocho>
               <Treintaynueve>' . (isset($datos['Treintaynueve']) ? $datos['Treintaynueve'] : '') . '</Treintaynueve>
               <Cuarenta>' . (isset($datos['Cuarenta']) ? $datos['Cuarenta'] : '') . '</Cuarenta>
               <Cuarentayuno>' . (isset($datos['Cuarentayuno']) ? $datos['Cuarentayuno'] : '') . '</Cuarentayuno>
               <Cuarentaydos>' . (isset($datos['Cuarentaydos']) ? $datos['Cuarentaydos'] : '') . '</Cuarentaydos>
               <Cuarentaytres>' . (isset($datos['Cuarentaytres']) ? $datos['Cuarentaytres'] : '') . '</Cuarentaytres>
               <Cuarentaycuatro>' . (isset($datos['Cuarentaycuatro']) ? $datos['Cuarentaycuatro'] : '') . '</Cuarentaycuatro>
               <Cuarentaycinco>' . (isset($datos['Cuarentaycinco']) ? $datos['Cuarentaycinco'] : '') . '</Cuarentaycinco>
               <Cuarentayseis>' . (isset($datos['Cuarentayseis']) ? $datos['Cuarentayseis'] : '') . '</Cuarentayseis>
               <Cuarentaysiete>' . (isset($datos['Cuarentaysiete']) ? $datos['Cuarentaysiete'] : '') . '</Cuarentaysiete>
               <Cuarentayocho>' . (isset($datos['Cuarentayocho']) ? $datos['Cuarentayocho'] : '') . '</Cuarentayocho>
               <Cuarentaynueve>' . (isset($datos['Cuarentaynueve']) ? $datos['Cuarentaynueve'] : '') . '</Cuarentaynueve>
               <Cincuenta>' . (isset($datos['Cincuenta']) ? $datos['Cincuenta'] : '') . '</Cincuenta>
           </Adicional>';

        return $xml;
    }

    protected function formateaNumero($numero)
    {
        return number_format($numero, 0, ',', '');
    }

    protected function ValidaDocumento()
    {
        $size = count($this->referencias);
        for ($i = 0; $i < $size; $i++) {
            $tipo1 = $this->referencias[$i]['TipoRef'];

            for ($j = 1; $j < $size; $j++) {
                $tipo2 = $this->referencias[$j]['TipoRef'];
                echo $tipo1.'-'.$tipo2.'<br>';

                if ($tipo1 != $tipo2) {
                    return false;
                } else {
                    if ($tipo1 == 33 || $tipo1 == 34 || $tipo1 == 39 || $tipo1 == 56) {
                        $validacion = true;
                    } else {
                        return false;
                    }
                }
            }

        }

        return $validacion;

    }

    protected function ValidaDireccion($direcionN, $direcionD)
    {
        if ($direcionN == $direcionD) {
            return true;
        } else {
            return false;
        }
    }



}
