<?php

namespace App\Models;

use DB;
use App\Models\Bodega;
use App\Models\Cliente;
use App\Models\FormaPago;
use App\Models\AreaNegocio;
use App\Models\Producto;
use App\Traits\Foliable;
use App\Traits\Integrable;

class Pedido {

    public function __construct(
            $id_empresa,
            $rut_empresa,
            $rut_usuario,
            $id_pedido,
            $receptor,
            $razon,
            $monto_neto,
            $monto_iva,
            $monto_total,
            $descuento,
            $observacion,

            array $detalles
        )
    {
        $this->id_empresa = $id_empresa;
        $this->rut_empresa = $rut_empresa;
        $this->emisor = Empresa::obtenEmpresa($rut_empresa);
        $this->rut_usuario = $rut_usuario;
        $this->tipo_documento = 0;
        $this->folio = 0;
        $this->id_pedido = $id_pedido;
        $this->receptor = $receptor;
        $this->razon = $razon;
        $this->monto_neto = $monto_neto;
        $this->monto_iva = $monto_iva;
        $this->monto_total = $monto_total;
        $this->descuento = $descuento;
        $this->observacion = $observacion;
        $this->detalles = $detalles;
    }

    protected function fallo($mensaje, $rollback = true, $registra_folio = true)
    {
        if($registra_folio){
            $this->registraFolioSinOcupar($this->rut_empresa, $this->tipo_documento, $this->folio);
        }
        if($rollback){
            $this->rollback();
        }
        return ['mensaje' => $mensaje];
    }

    public function ingresarPedido()
    {


        if(is_null($this->receptor)) {
            return $this->fallo('Receptor invalido.', false, false);
        }

        //forma de pago
        /*$formaPago = FormaPago::obtenFormaPagoWoopy($this->rut_empresa);
        if(is_null($formaPago)) {
            return $this->fallo('Debe tener una forma de pago por defecto para woopy.', false, false);
        }*/
        //area de Negocio
        /*$areaNegocio = AreaNegocio::obtenAreaNegocioWoopy($this->rut_empresa);
        if(is_null($areaNegocio)) {
            return $this->fallo('Debe tener un Area de Negocio por defecto para woopy.', false, false);
        }*/

        //vendedor
        /*$vendedor = Vendedor::obtenVendedorWoopy($this->rut_usuario, $this->rut_empresa);
        if(is_null($vendedor)) {
            return $this->fallo('Vendedor '.$this->rut_usuario.' No configurado para woopy.', false, false);
        }*/


        /*$this->folio = $this->obtenFolio(
            $this->rut_empresa,
            $this->tipo_documento
        );*/
        $this->folio = $this->id_pedido;

        /*if(is_null($this->folio)) {
            return $this->fallo('No se pudo obtener folio.', false, true);
        }*/

        $this->adicionales['Siete'] = isset($this->observacion) ? $this->observacion : '';


        $id_pedido = $this->ingresoLibroPedido();
        if( !$id_pedido ){
            return $this->fallo('Excepción al ingresar datos libro pedidos.');
        }

        $totalDetalle = 0;
        foreach($this->detalles as $detalle){

            /*$bodega = Bodega::obtenBodegaWoopy($this->rut_empresa);
            if(is_null($bodega)){
                return $this->fallo('Debe tener una Bodega por defecto woopy.');
            }*/

            /*$producto = Producto::obtenProducto($detalle['Codigo'], $this->rut_empresa);
            if(is_null($producto)){
                return $this->fallo('Producto '.$detalle['Codigo'].' No existe.');
            }*/

            //$detalle['Precio'] = !isset($detalle['Precio']) ? $producto->VALOR_PRODUCTO : $detalle['Precio'];
            $detalle['Precio'] = $detalle['Precio'];

            if($detalle['Afecto']){
                $exento = 0;
                $neto = round(($detalle['Precio'] * $detalle['Cantidad']), 0, PHP_ROUND_HALF_UP);
                $total = round(($neto - $detalle['Descuento']), 0, PHP_ROUND_HALF_UP);
                $id_usuario = '';
                $totalDetalle += $total;
            }


            if(!$this->ingresaDetalle($detalle, $exento, $neto, $total, $id_usuario, $id_pedido)){
                return $this->fallo('No se pudo realizar el ingreso de detalle.');
            }

        }

        return [
            'mensaje' => 'Pedido guardado con exito.',
            'folio' =>  $this->folio,
            //'pdf' => $respuesta->XmlDetalleConsultas->IdDoc->UrlsPDF->UrlPDF,
        ];


    }

    protected function ingresoLibroPedido()
    {
        try{
        $ingreso = DB::table('pedido')
            ->insert([
                'rut' => $this->rut_empresa,
                'mes' => date('m', time()),
                'fecha' => date('Y-m-d', time()),
                'tipo_doc' => $this->tipo_documento,
                'n_doc' => $this->folio,
                'id_pedido' => $this->id_pedido,
                'rut_c' => strtoupper($this->receptor),
                'nombre_c' => $this->razon,
                'exento' => 0,
                'valor_n' => $this->monto_neto,
                'valor_i' => $this->monto_iva,
                'valor_t' => $this->monto_total,
                'periodo' => date('Y', time()),
                'observacion' => $this->observacion,
                'rut_usuario' => $this->rut_usuario,
                'estado' => 1,
                'datos_empresa_id' => $this->id_empresa,
            ]);

        }catch (Exception $e) {
            return false;
        }

        return $ingreso;
    }





    protected function ingresaDetalle($detalle,$exento, $neto, $total, $id_usuario, $id_pedido)
    {
        try{
            $ingreso = DB::table('detalle_pedido')
                ->insert([
                    'rut_empresa' => $this->rut_empresa,
                    'codigo' => $detalle['Codigo'],
                    'detalle' => $detalle['Detalle'],
                    'exento' => $this->formateaNumero($exento),
                    'neto' => $this->formateaNumero($neto),
                    'cantidad' => $this->formateaNumero($detalle['Cantidad']),
                    'tipodesc' => 1,
                    'vadesc' => $detalle['Descuento'],
                    'desc' => $detalle['Descuento'],
                    'total' => $this->formateaNumero($total),
                    'libro_pedido_id' => $id_pedido,

                ]);
        } catch(Exception $e) {
            return false;
        }

        return $ingreso;
    }





    protected function rollback(){
        $ingreso = DB::table('pedido')
            ->whereRaw('rut = \''.$this->rut_empresa.'\'')
            ->where('tipo_doc', '=', $this->tipo_documento)
            ->where('n_doc', '=', $this->folio)
            ->delete();


        $ingreso = DB::table('detalle_pedido')
            ->whereRaw('RUT_EMPRESA = \''.$this->rut_empresa.'\'')
            ->where('ID_TIPODOC', '=', $this->tipo_documento)
            ->where('ID_CORRE_DETALLEDOC', '=', $this->folio)
            ->delete();
    }


    protected function formateaNumero($numero)
    {
        return number_format($numero, 0, ',', '');
    }
}
