<?php

namespace App\Traits;

use DB;
use SoapClient;

trait Integrable
{
    public function generaXmlIntegracion($datos)
    {
        $xml = '<?xml version="1.0" encoding="ISO-8859-1"?>
            <Integracion>
               <Emisor>
        	       <Rut>'.(isset($datos['Rut']) ? $datos['Rut'] : '').'</Rut>
        	       <Token></Token>
               </Emisor>
               <Parametros>
        	       <Productivo>'.(isset($datos['Productivo']) ? $datos['Productivo'] : '').'</Productivo>
        	       <Operacion>'.(isset($datos['Operacion']) ? $datos['Operacion'] : '').'</Operacion>
        	       <AsignarFolio>'.(isset($datos['AsignarFolio']) ? $datos['AsignarFolio'] : '').'</AsignarFolio>
        	       <DTEBasico>'.(isset($datos['DTEBasico']) ? $datos['DTEBasico'] : '').'</DTEBasico>
                   <BoletaBasica>'.(isset($datos['BoletaBasica']) ? $datos['BoletaBasica'] : '').'</BoletaBasica>
                   <Adicionales>'.(isset($datos['Adicionales']) ? $datos['Adicionales'] : '').'</Adicionales>
        		   <IdDoc>
        		   		<TipoDTE>'.(isset($datos['TipoDTE']) ? $datos['TipoDTE'] : '').'</TipoDTE>
        		   		<Folio>'.(isset($datos['Folio']) ? $datos['Folio'] : '').'</Folio>
        		   		<RutEmisor></RutEmisor>
        		   		<EmitidoRecibido></EmitidoRecibido>
        		   		<RutReceptor></RutReceptor>
        		   		<FechaInicial></FechaInicial>
        		   		<FechaFinal></FechaFinal>
        		   		<Cedible>'.(isset($datos['Cedible']) ? $datos['Cedible'] : '').'</Cedible>
        		   		<Regenerar>1</Regenerar>
        		   </IdDoc>
               </Parametros>
           </Integracion>';

       return $xml;
    }

    public function integrar($xml)
    {

        $servicio = DB::table('ws')
            ->where('RUT_EMPRESA', '=', 'default')
            ->first();

        if(is_null($servicio)) {
            return false;
        }

        $cliente = new SoapClient($servicio->WS, array('soap_version' => SOAP_1_2));
        $vem = $cliente->Integracion(array('StringXMLIntegracion' => utf8_encode($xml)));

        return $vem;
    }

    public function consultaPDF($datos)
    {
        $xml_consulta_pdf = '<?xml version="1.0" encoding="ISO-8859-1"?>
<Integracion>
<Emisor>
<Rut>'.(isset($datos['rut']) ? $datos['rut'] : '').'</Rut>
<Token />
</Emisor>
<Parametros>
<Productivo>1</Productivo>
<Operacion>consultapdf</Operacion>
<AsignarFolio>0</AsignarFolio>
<IdDoc>
<TipoDTE>'.(isset($datos['tipo']) ? $datos['tipo'] : '').'</TipoDTE>
<Folio>'.(isset($datos['folio']) ? $datos['folio'] : '').'</Folio>
<RutEmisor/>
<EmitidoRecibido>E</EmitidoRecibido>
<RutReceptor />
<FechaInicial />
<FechaFinal />
<Cedible>'.(isset($datos['cedible']) ? $datos['cedible'] : '').'</Cedible>
<TipoImpreso></TipoImpreso>
<Regenerar>1</Regenerar>
 </IdDoc>
<cesion>
<rutcesionario>
</rutcesionario>
<rznsocialcesionario>
</rznsocialcesionario>
 <direccioncesionario>
 </direccioncesionario>
 <emailcesionario>
 </emailcesionario>
<contactoempresa>
 </contactoempresa>
 <mailcontacto>
</mailcontacto>
 <rutautorizado>
 </rutautorizado>
 <nombreautorizado>
 </nombreautorizado>
<folio>
</folio>
<tipo>
 </tipo>
 <montocesion>
 </montocesion>
 <ultimovencimiento>
 </ultimovencimiento>
 <emaildeudor>
 </emaildeudor>
</cesion>
<DTEBasico>
</DTEBasico>
<RecepcionDTEs>
  <FechaRecepcionInicial>
  </FechaRecepcionInicial>
  <FechaRecepcionFinal>
  </FechaRecepcionFinal>
 </RecepcionDTEs>
<recibidosensii>
 </recibidosensii>
<Adicionales>
</Adicionales>
<CAFSII />
<IdLibro>
  <TipoOperacion />
  <Tipolibro />
  <TipoEnvio />
  <Periodo />
 <FolioNotificacion />
 <CodAutRec />
 <FechaInicial />
 <FechaFinal />
 <FolioInicial />
 <FolioFinal />
 <RutReceptor />
 <TposDocEspecial />
</IdLibro>
<LibroCSV />
 <cedente>
  <rutcedente />
 <rznsoccedente />
  <rutautorizado />
  <nombreautorizado />
 <passwordPFX />
  <firmabinbase64 />
  <passwordcedente />
</cedente>
 </Parametros>
</Integracion>';

    return $xml_consulta_pdf;
    }
}
