<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Traits\Autenticable;
use DB;

class ComprasController extends Controller
{
    use Autenticable;

    public function obten_compras_por_pagar(Request $request)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $compras_a_pagar = DB::table('ctactep')
            ->select('ctactep.rut_c as rut_cliente', 'nombre_c as cliente',DB::raw('COUNT(ctactep.rut_c) as Documentos'),DB::raw('SUM(saldo_ctacte) as Monto'))
            ->join('libro_compras3', 'ctactep.ID_LCOMPRAS', '=', 'libro_compras3.ID_LCOMPRAS')
            ->where('RUT_EMPRESA', '=', $usuario->rut_empresa)
            ->where('saldo_ctacte', '!=', 0)
            ->where('DISPONIBLE5_LCOMPRAS', '!=', 2)
            ->where('CTACTE_LCOMPRAS', '=', 1)
            ->groupBy('ctactep.rut_c')
            ->get();

        return response()->json((array) $compras_a_pagar);
    }

    public function obtenComprasPorPagarPorProveedor(Request $request, $rut)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $compras_a_pagar = DB::table('ctactep')
            ->select('ctactep.tipo_doc as tipo_documento', 'ctactep.n_doc_ctacte as numero_documento','libro_compras3.fecha','total_ctacte as total','pagos_ctacte as abono','saldo_ctacte as monto')
            ->join('libro_compras3', 'ctactep.ID_LCOMPRAS', '=', 'libro_compras3.ID_LCOMPRAS')
            ->where('RUT_EMPRESA', '=', $usuario->rut_empresa)
            ->where('saldo_ctacte', '!=', 0)
            ->where('DISPONIBLE5_LCOMPRAS', '!=', 2)
            ->where('CTACTE_LCOMPRAS', '=', 1)
            ->get();

        return response()->json((array) $compras_a_pagar);
    }
}
